# generated by datamodel-codegen:
#   filename:  governance/workflows/workflowInstance.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class WorkflowStatus(Enum):
    RUNNING = 'RUNNING'
    FINISHED = 'FINISHED'
    FAILURE = 'FAILURE'
    EXCEPTION = 'EXCEPTION'


class WorkflowInstance(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this workflow instance state.'),
    ]
    workflowDefinitionId: Annotated[
        Optional[basic.Uuid], Field(None, description='Workflow Definition Id.')
    ]
    startedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp on which the workflow instance started.'),
    ]
    endedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Timestamp on which the workflow instance ended.'),
    ]
    variables: Optional[Dict[str, Any]] = None
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp on which the workflow instance state was created.',
        ),
    ]
    status: Optional[WorkflowStatus] = None
    exception: Optional[str] = None
