# generated by datamodel-codegen:
#   filename:  type/jdbcConnection.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DriverClass(RootModel[str]):
    root: Annotated[str, Field(description='Type used for JDBC driver class.')]


class ConnectionUrl(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Type used for JDBC connection URL of format `url_scheme://<username>:<password>@<host>:<port>/<db_name>`.'
        ),
    ]


class JdbcInfo(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    driverClass: DriverClass
    connectionUrl: ConnectionUrl


class JdbcConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    driverClass: Annotated[DriverClass, Field(description='JDBC driver class.')]
    connectionUrl: Annotated[ConnectionUrl, Field(description='JDBC connection URL.')]
    userName: Annotated[str, Field(description='Login user name.')]
    password: Annotated[str, Field(description='Login password.')]
