# generated by datamodel-codegen:
#   filename:  type/tagLabel.json
#   timestamp: 2025-09-17T09:05:18+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class LabelType(Enum):
    Manual = 'Manual'
    Propagated = 'Propagated'
    Automated = 'Automated'
    Derived = 'Derived'
    Generated = 'Generated'


class State(Enum):
    Suggested = 'Suggested'
    Confirmed = 'Confirmed'


class TagFQN(RootModel[str]):
    root: str


class TagSource(Enum):
    Classification = 'Classification'
    Glossary = 'Glossary'


class TagLabel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    tagFQN: TagFQN
    name: Annotated[
        Optional[str], Field(None, description='Name of the tag or glossary term.')
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name that identifies this tag.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description for the tag label.'),
    ]
    style: Optional[basic.Style] = None
    source: Annotated[TagSource, Field(description='Label is from Tags or Glossary.')]
    labelType: Annotated[
        LabelType,
        Field(
            description="Label type describes how a tag label was applied. 'Manual' indicates the tag label was applied by a person. 'Derived' indicates a tag label was derived using the associated tag relationship (see Classification.json for more details). 'Propagated` indicates a tag label was propagated from upstream based on lineage. 'Automated' is used when a tool was used to determine the tag label."
        ),
    ]
    state: Annotated[
        State,
        Field(
            description="'Suggested' state is used when a tag label is suggested by users or tools. Owner of the entity must confirm the suggested labels before it is marked as 'Confirmed'."
        ),
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to the tag resource.')
    ]
