from typing import Dict, Any, Literal
from typing import Any, Protocol, Sequence

from psycopg.sql import Composable

Row = Dict[str, Any]


class CursorABC(Protocol):
    def execute(
        self,
        operation: str | Composable,
        parameters: Sequence[Any] | None = None,
    ) -> None: ...
    def executemany(
        self,
        operation: str | Composable,
        seq_of_parameters: Sequence[Sequence[Any]],
    ) -> None: ...
    def fetchone(self) -> Row | None: ...
    def fetchmany(self, size: int | None = None) -> list[Row]: ...
    def fetchall(self) -> list[Row]: ...
    def close(self) -> None: ...
    def setinputsizes(self, sizes: Sequence[Any]) -> None: ...
    def setoutputsize(self, size: Any, column: Any = None) -> None: ...

    @property
    def rowcount(self) -> int | Literal[-1]: ...
    @property
    def lastrowid(self) -> int | None: ...


class ConnectionABC(Protocol):
    def cursor(self) -> CursorABC: ...
    def commit(self) -> None: ...
    def rollback(self) -> None: ...
    def close(self) -> None: ...


class CursorAsyncABC(Protocol):
    async def execute(
        self,
        operation: str | Composable,
        parameters: Sequence[Any] | None = None,
    ) -> None: ...
    async def executemany(
        self,
        operation: str | Composable,
        seq_of_parameters: Sequence[Sequence[Any]],
    ) -> None: ...
    async def fetchone(self) -> Row | None: ...
    async def fetchmany(self, size: int | None = None) -> list[Row]: ...
    async def fetchall(self) -> list[Row]: ...
    async def close(self) -> None: ...
    def setinputsizes(self, sizes: Sequence[Any]) -> None: ...
    def setoutputsize(self, size: Any, column: Any = None) -> None: ...

    @property
    def rowcount(self) -> int | Literal[-1]: ...
    @property
    def lastrowid(self) -> int | None: ...


class ConnectionAsyncABC(Protocol):
    async def cursor(self) -> CursorAsyncABC: ...
    async def commit(self) -> None: ...
    async def rollback(self) -> None: ...
    async def close(self) -> None: ...
