import pandas as pd
from importlib.resources import files

#MOUSE 

def get_mouse_color_dict(path):
    color_df = pd.read_csv(path)
    color_df['key'] = color_df['id'].astype(str) + ' ' + color_df['label']
    color_keys = color_df['key']
    color_values = color_df['color']
    color_dict = dict(zip(color_keys,color_values))
    return color_dict

mouse_colors_subclass =   get_mouse_color_dict(files('morph_utils') / 'data/AIT21.0_colors_subclass.csv')
mouse_colors_supertype =  get_mouse_color_dict(files('morph_utils') / 'data/AIT21.0_colors_supertype.csv')
mouse_colors_cluster =    get_mouse_color_dict(files('morph_utils') / 'data/AIT21.0_colors_cluster.csv')
mouse_colors_cluster_wb = get_mouse_color_dict(files('morph_utils') / 'data/WB_colorpal_cluster.csv')

mouse_inhib_vis_met_colors = {
        "Sst-MET-1": "#b9bb67",
    "Sst-MET-2": "#804811",
    "Sst-MET-3": "#CC6D3D",
    "Sst-MET-4": "#f9a072",
    "Sst-MET-5": "#FFDF11",
    "Sst-MET-6": "#D6C300",
    "Sst-MET-7": "#BF9F00",
    "Sst-MET-8": "#806B19",
    "Sst-MET-9": "#BF8219",
    "Sst-MET-10": "#802600",
    "Sst-MET-11": "#FFBB33",
    "Sst-MET-12": "#B95541",
    "Sst-MET-13": "#C11331",
    "Pvalb-MET-1": "#ED4C50",
    "Pvalb-MET-2": "#C94545",
    "Pvalb-MET-3": "#ff2c26",
    "Pvalb-MET-4": "#E67A77",
    "Pvalb-MET-5": "#FF197F",
    "Lamp5-MET-1": "#FF7290",
    "Lamp5-MET-2": "#C77963",
    "Sncg-MET-1": "#C266D1",
    "Sncg-MET-2": "#9900B3",
    "Sncg-MET-3": "#9440F3",
    "Vip-MET-1": "#BD3D9A",
    "Vip-MET-2": "#FF00FF",
    "Vip-MET-3": "#756FB3",
    "Vip-MET-4": "#9FAAFF",
    "Vip-MET-5": "#AD589A",
}

mouse_exc_vis_met_colors = {
    'IT-MET-1': '#7AE6AB',
    'IT-MET-2': '#00979D',
    'IT-MET-3': '#00DDC5',
    'IT-MET-4': '#00A809',
    'IT-MET-5': '#26BF64',
    'IT-MET-8': '#5100FF',
    'IT-MET-6': '#96E32C',
    'IT-MET-7': '#A19922',
    'NP-MET-1': '#73CA95',
    'CT-MET-1': '#74CAFF',
    'L6b-MET-3': '#254566',
    'L6b-MET-2': '#336D99',
    'L6b-MET-1': '#2B7880',
    'ET-MET-1': '#0000FF',
    'ET-MET-3': '#29E043',
    'ET-MET-2': '#22737F',
    'Gnb4': '#5100FF',
    'Chrna6': '#5B7586',
    'Nxph4': '#2B7880',
    'L6b/Nxph4': '#2B7880',
    'L6b': '#2B7880',
    'Gnb4/IT-MET-8': '#5100FF',
    'ET-MET-1*': '#02075D',
    'L2/3 IT': '#7AE6AB',
    'L4 IT': '#00979D',
    'L4/L5 IT': '#00DDC5',
    'L5 IT-1': '#00A809',
    'L5 IT-2 Pld5': '#26BF64',
    'L6 IT-1': '#96E32C',
    'L6 IT-2': '#A19922',
    'L5/L6 IT Car3': '#5100FF',
    'L5 ET-1 Chrna6': '#0000FF',
    'L5 ET-2': '#22737F',
    'L5 ET-3 Stac': '#29E043',
    'L5 NP': '#73CA95',
    'L6 CT': '#74CAFF',
    'L6b-1': '#2B7880',
    'L6b-2 Ngf': '#336D99',
    'L6b-3': '#254566',
    'L5 ET-1*': '#02075D'
}

#NHP

nhp_colors_level3_subclass =  {
    'D1-Matrix':'#996F2E',
    'D2-Striosome':'#77CC3D',
    'D2-Matrix':'#649900',
    'D2-Hybrid-MCHR2':'#A5CC1F',
    'D1D2-Hybrid':'#EDFF4D',
    'LHX6-TAC3-PLPP4':'#3DC3CC',
    'D1-Striosome':'#999745',
    'SLC17A7-SATB2':'#6C1799',
    'PVALB-COL19A1-ST18':'#2C0099',
    'LHX6-SATB1':'#73FFF6',
    'CCK-VIP-TAC3':'#993717',
    'CCK-FBXL7':'#CC4F3D',
    'SST-RSPO2':'#994578',
    'SST_Chodl':'#FF4DA4',
    'D2-ShellOT':'#BDFF73',
    'CHAT':'#FF5E00',
    'D1-ShellOT':'#CCAF00',
    'D1-NUDAP':'#FFC526',
    'TAC3-LHX8-PLPP4':'#CC1F5E',
    'MEIS2':'#00B1FF',
    'SN_STH_GPe-MEIS2-OTX2':'#FF26E0',
    'LHX6-LHX8-GBX1':'#00997D',
    'LHX6_SST':'#178199',
    'NAc-CCK-SEMA3A':'#002ACC',
    'GP-LHX6':'#00CC43',
    'SST-ADARB2':'#CC0096',
    'SLC17A6':'#AC73FF',
    'WDR49-ADAM12':'#FF7384',
    'D1-ICj':'#CC935C',
    'NAc-LHX8':'#454C99'}

#HUMAN

human_colors_ttype = {
    'Inh L1-2 PAX6 CDH12': '#DDACC9',
    'Inh L1-2 PAX6 TNFAIP8L3': '#FF88AD',
    'Inh L1 SST NMBR (ADARB2+)': '#E67B73',
    'Inh L1-A4 LAMP5 LCP2 (rosehip)': '#FFA388',
    'Inh L1-2 LAMP5 DBP': '#FF7466',
    'Inh L2-6 LAMP5 CA1 (Igtp)': '#C77963',
    'Inh L1 SST CHRNA4 (ADARB2+)': '#DD6091',
    'Inh L1-2 GAD1 MC4R (ADARB2+)': '#FF7290',
    'Inh L1-2 SST BAGE2 (ADARB2+)': '#9440F3',
    'Inh L1-3 PAX6 SYT6 (Sncg)': '#9900B3',
    'Inh L1-2 VIP TSPAN12': '#6C00BF',
    'Inh L1-4 VIP CHRNA6': '#7A0099',
    'Inh L1-3 VIP ADAMTSL1': '#7779BF',
    'Inh L3-6 VIP HS3ST3A1': '#FF00FF',
    'Inh L1-2 VIP PCDH20': '#BD3D9A',
    'Inh L2-5 VIP SERPINF1': '#B09FFF',
    'Inh L2-5 VIP TYR': '#FF4DC1',
    'Inh L1-3 VIP CHRM2': '#9FAAFF',
    'Inh L2-4 VIP CBLN1': '#756FB3',
    'Inh L1-3 VIP CCDC184': '#FF00B3',
    'Inh L1-3 VIP GGH': '#B3128A',
    'Inh L1-2 VIP LBH': '#AF00E6',
    'Inh L2-3 VIP CASC6': '#992E81',
    'Inh L2-4 VIP SPAG17': '#A711C1',
    'Inh L1-4 VIP OPRM1': '#9F219D',
    'Inh L3-6 SST NPY (Chodl)': '#FFDA50',
    'Inh L3-6 SST HPGD': '#D9C566',
    'Inh L4-6 SST B3GAT2': '#FFBB33',
    'Inh L5-6 SST KLHDC8A': '#C11331',
    'Inh L5-6 SST NPM1P10': '#BF8219',
    'Inh L4-6 SST GXYLT2': '#802600',
    'Inh L4-5 SST STK32A': '#806B19',
    'Inh L1-3 SST CALB1': '#BF480D',
    'Inh L3-5 SST ADGRG6': '#804811',
    'Inh L2-4 SST FRZB': '#FF554D',
    'Inh L5-6 SST TH': '#A81111',
    'Inh L5-6 GAD1 GLP1R (LHX6+)': '#FF2F7E',
    'Inh L5-6 PVALB LGR5': '#ED4C50',
    'Inh L4-5 PVALB MEPE': '#994C00',
    'Inh L2-4 PVALB WFDC2': '#BC2B11',
    'Inh L4-6 PVALB SULF1': '#E62A5D',
    'Inh L5-6 SST MIR548F2': '#D6221D',
    'Inh L2-5 PVALB SCUBE3 (chandelier)': '#FF197F',
    'Exc L2 LAMP5 LTK': '#D9F077',
    'Exc L2-4 LINC00507 GLP2R': '#A6E6A9',
    'Exc L2-3 LINC00507 FREM3': '#7AE6AB',
    'Exc L5-6 THEMIS C1QL3': '#A19922',
    'Exc L3-4 RORB CARM1P1': '#00979D',
    'Exc L3-5 RORB ESR1': '#00DDC5',
    'Exc L3-5 RORB COL22A1': '#00A79D',
    'Exc L3-5 RORB FILIP1L': '#0094C2',
    'Exc L4-5 RORB FOLH1B': '#00A809',
    'Exc L4-6 RORB SEMA3E': '#26FFF2',
    'Exc L4-5 RORB DAPK2': '#00FF00',
    'Exc L5-6 RORB TTC12': '#26BF64',
    'Exc L4-6 RORB C1R': '#008F1F',
    'Exc L4-5 FEZF2 SCN4B (PT)': '#104F00',
    'Exc L5-6 THEMIS DCSTAMP': '#5100FF',
    'Exc L5-6 THEMIS CRABP1': '#8046FF',
    'Exc L5-6 THEMIS FGF10': '#B08BFF',
    'Exc L4-6 FEZF2 IL26 (NP)': '#73CA95',
    'Exc L5-6 FEZF2 ABO': '#1F6666',
    'Exc L5-6 SLC17A7 IL15': '#336D99',
    'Exc L5-6 FEZF2 EFTUD1P1': '#335280',
    'THEMIS (L6)|b': '#9A6EFF',
    'PVALB|c': '#D22B43',
    'RORB (L4)|c': '#54BABD',
    'L2-L3|b': '#C1EB92',
    'PVALB|b': '#C13837',
    'SST|e': '#A36012',
    'SST|d': '#E28532',
    'RORB (L5)': '#1BA94A',
    'VIP|i': '#8C90DC',
    'L1-L2 ADARB2|b': '#EF6991',
    'THEMIS (L6)|a': '#865AFF',
    'VIP|l': '#A31AB0',
    'VIP|k': '#A421BA',
    'VIP|h': '#BA75CF',
    'LAMP5|c': '#FF8D78',
    'SST|g': '#A3480F',
    'PVALB|a': '#C63331',
    'FEZF2 (L6b)|c': '#367B99',
    'RORB (L4-L5)|b': '#1BFFAB',
    'RORB (L4)|b': '#45B4B3',
    'VIP|d': '#D800FF',
    'SST|c': '#C57426',
    'L2-L3|a': '#ADE99B',
    'L1-L2 ADARB2|a': '#D55EB7',
    'VIP|g': '#B866C0',
    'RORB (L4-L5)|a': '#16E68C',
    'PVALB (all)|b': '#CF3939',
    'LAMP5|b': '#EE8772',
    'FEZF2 (L6b)|b': '#316C8A',
    'SST|f': '#C64D2E',
    'PAX6': '#EF9BBC',
    'VIP (Sncg-like)': '#7300AD',
    'SST|b': '#B97223',
    'RORB (L4)|a': '#3CBFB7',
    'VIP|c': '#CF23E2',
    'PVALB (all)|a': '#D83849',
    'VIP (Igfbp6)': '#5E609E',
    'VIP|j': '#A41EB5',
    'FEZF2 (L6b)|a': '#316688',
    'L2-L3 or L6': '#AAD887',
    'SST|a': '#BF8435',
    'RORB (L3-L4, all)': '#35B8B2',
    'LAMP5|a': '#EC8472',
    'VIP or Sncg': '#8100AF',
    'VIP|f': '#AE4BBB',
    'RORB (L4-L5, all)': '#18CF76',
    'SST (all)|b': '#C17433',
    'VIP|b': '#D454E2',
    'RORB (all)': '#29C497',
    'SST (all)|a': '#BF6E30',
    'VIP|a': '#BE4ECB',
    'VIP+ |b': '#B042B3',
    'FEZF2 (L6b, all)': '#2E6682',
    'L1-L5|b': '#61CA93',
    'VIP+ |a': '#9F4BAE',
    'VIP+ (all)': '#B34DC0',
    'LHX6|c': '#C95E3B',
    'LAMP5/PAX6': '#ED8C8F',
    'L1-L5|a': '#5EC48E',
    'L1-L6': '#66B7A6',
    'LHX6|b': '#CC693C',
    'FEZF2 (all)': '#3F7D85',
    'ADARB2': '#C15FB7',
    'LHX6|a': '#CF6642',
    'Excitatory': '#5EAA9F',
    'Inhibitory': '#C76293',
    'FAIL': '#888888',
    'Inh L2-6 VIP QPCT': '#A700FF',
    'Inh L1-4 VIP PENK': '#3C3D73',
    'Exc L6 FEZF2 OR2T8': '#254566',
    'Exc L3-5 RORB TWIST2': '#77D9B7',
    'Exc L6 FEZF2 SCUBE1': '#388899'}