"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const core_1 = require("aws-cdk-lib/core");
const bundling_1 = require("./bundling");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * A lambda layer version.
 *
 */
let PythonLayerVersion = class PythonLayerVersion extends lambda.LayerVersion {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonLayerVersion);
            }
            throw error;
        }
        const compatibleRuntimes = props.compatibleRuntimes ?? [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = props.compatibleArchitectures ?? [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
                skip: !core_1.Stack.of(scope).bundlingRequired,
                ...props.bundling,
            }),
        });
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
    }
};
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonLayerVersion", version: "2.212.0-alpha.0" };
/** Uniquely identifies this class. */
PythonLayerVersion.PROPERTY_INJECTION_ID = '@aws-cdk.aws-lambda-python-alpha.PythonLayerVersion';
exports.PythonLayerVersion = PythonLayerVersion = __decorate([
    prop_injectable_1.propertyInjectable
], PythonLayerVersion);
//# sourceMappingURL=data:application/json;base64,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