"""
FastAPI

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from typing import Annotated, Any

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, validate_call

from code_size_analyzer_client.api_client import ApiClient, RequestSerialized
from code_size_analyzer_client.api_response import ApiResponse
from code_size_analyzer_client.models.application_combination import (
    ApplicationCombination,
)
from code_size_analyzer_client.models.response_get_app_analysis_details import (
    ResponseGetAppAnalysisDetails,
)
from code_size_analyzer_client.models.target_info import TargetInfo
from code_size_analyzer_client.rest import RESTResponseType


class ResultsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_app_analysis_details(
        self,
        stack: StrictStr,
        target: StrictStr,
        build: list[StrictStr | None],
        app_name: list[StrictStr | None],
        compiler: StrictStr | None = None,
        board: StrictStr | None = None,
        result_format: StrictStr | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResponseGetAppAnalysisDetails:
        """Get App Analysis Details

        Get the detailed analysis results for one or more apps

        :param stack: (required)
        :type stack: str
        :param target: (required)
        :type target: str
        :param build: (required)
        :type build: List[Optional[str]]
        :param app_name: (required)
        :type app_name: List[Optional[str]]
        :param compiler:
        :type compiler: str
        :param board:
        :type board: str
        :param result_format:
        :type result_format: str
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_analysis_details_serialize(
            stack=stack,
            target=target,
            build=build,
            app_name=app_name,
            compiler=compiler,
            board=board,
            result_format=result_format,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "ResponseGetAppAnalysisDetails",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_app_analysis_details_with_http_info(
        self,
        stack: StrictStr,
        target: StrictStr,
        build: list[StrictStr | None],
        app_name: list[StrictStr | None],
        compiler: StrictStr | None = None,
        board: StrictStr | None = None,
        result_format: StrictStr | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResponseGetAppAnalysisDetails]:
        """Get App Analysis Details

        Get the detailed analysis results for one or more apps

        :param stack: (required)
        :type stack: str
        :param target: (required)
        :type target: str
        :param build: (required)
        :type build: List[Optional[str]]
        :param app_name: (required)
        :type app_name: List[Optional[str]]
        :param compiler:
        :type compiler: str
        :param board:
        :type board: str
        :param result_format:
        :type result_format: str
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_analysis_details_serialize(
            stack=stack,
            target=target,
            build=build,
            app_name=app_name,
            compiler=compiler,
            board=board,
            result_format=result_format,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "ResponseGetAppAnalysisDetails",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_app_analysis_details_without_preload_content(
        self,
        stack: StrictStr,
        target: StrictStr,
        build: list[StrictStr | None],
        app_name: list[StrictStr | None],
        compiler: StrictStr | None = None,
        board: StrictStr | None = None,
        result_format: StrictStr | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get App Analysis Details

        Get the detailed analysis results for one or more apps

        :param stack: (required)
        :type stack: str
        :param target: (required)
        :type target: str
        :param build: (required)
        :type build: List[Optional[str]]
        :param app_name: (required)
        :type app_name: List[Optional[str]]
        :param compiler:
        :type compiler: str
        :param board:
        :type board: str
        :param result_format:
        :type result_format: str
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_analysis_details_serialize(
            stack=stack,
            target=target,
            build=build,
            app_name=app_name,
            compiler=compiler,
            board=board,
            result_format=result_format,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "ResponseGetAppAnalysisDetails",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_app_analysis_details_serialize(
        self,
        stack,
        target,
        build,
        app_name,
        compiler,
        board,
        result_format,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {
            "build": "multi",
            "app_name": "multi",
        }

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        if stack is not None:
            _query_params.append(("stack", stack))

        if target is not None:
            _query_params.append(("target", target))

        if build is not None:
            _query_params.append(("build", build))

        if app_name is not None:
            _query_params.append(("app_name", app_name))

        if compiler is not None:
            _query_params.append(("compiler", compiler))

        if board is not None:
            _query_params.append(("board", board))

        if result_format is not None:
            _query_params.append(("result_format", result_format))

        if warehouse is not None:
            _query_params.append(("warehouse", warehouse))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_app_analysis_details",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_app_combinations(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> list[ApplicationCombination]:
        """Get App Combinations

        Get the set of combinations of app name / compiler / stack / target / board

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_combinations_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[ApplicationCombination]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_app_combinations_with_http_info(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[list[ApplicationCombination]]:
        """Get App Combinations

        Get the set of combinations of app name / compiler / stack / target / board

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_combinations_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[ApplicationCombination]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_app_combinations_without_preload_content(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get App Combinations

        Get the set of combinations of app name / compiler / stack / target / board

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_combinations_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[ApplicationCombination]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_app_combinations_serialize(
        self,
        disable_cache,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        if disable_cache is not None:
            _query_params.append(("disable_cache", disable_cache))

        if warehouse is not None:
            _query_params.append(("warehouse", warehouse))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_app_combinations",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_app_stack_names(
        self,
        branch: list[StrictStr | None],
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Get App Stack Names

        Get the list of all analyzed app & stack combinations, filtered by branch

        :param branch: (required)
        :type branch: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_stack_names_serialize(
            branch=branch,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_app_stack_names_with_http_info(
        self,
        branch: list[StrictStr | None],
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Get App Stack Names

        Get the list of all analyzed app & stack combinations, filtered by branch

        :param branch: (required)
        :type branch: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_stack_names_serialize(
            branch=branch,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_app_stack_names_without_preload_content(
        self,
        branch: list[StrictStr | None],
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get App Stack Names

        Get the list of all analyzed app & stack combinations, filtered by branch

        :param branch: (required)
        :type branch: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_stack_names_serialize(
            branch=branch,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_app_stack_names_serialize(
        self,
        branch,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {
            "branch": "multi",
        }

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        if branch is not None:
            _query_params.append(("branch", branch))

        if warehouse is not None:
            _query_params.append(("warehouse", warehouse))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_app_stack_names",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_app_summary_records(
        self,
        stack: StrictStr,
        application_name: StrictStr,
        branch: list[StrictStr | None] | None = None,
        sdk_commit_hash: list[StrictStr | None] | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Get App Summary Records

        Get the high-level analysis results for an app

        :param stack: (required)
        :type stack: str
        :param application_name: (required)
        :type application_name: str
        :param branch:
        :type branch: List[Optional[str]]
        :param sdk_commit_hash:
        :type sdk_commit_hash: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_summary_records_serialize(
            stack=stack,
            application_name=application_name,
            branch=branch,
            sdk_commit_hash=sdk_commit_hash,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_app_summary_records_with_http_info(
        self,
        stack: StrictStr,
        application_name: StrictStr,
        branch: list[StrictStr | None] | None = None,
        sdk_commit_hash: list[StrictStr | None] | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Get App Summary Records

        Get the high-level analysis results for an app

        :param stack: (required)
        :type stack: str
        :param application_name: (required)
        :type application_name: str
        :param branch:
        :type branch: List[Optional[str]]
        :param sdk_commit_hash:
        :type sdk_commit_hash: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_summary_records_serialize(
            stack=stack,
            application_name=application_name,
            branch=branch,
            sdk_commit_hash=sdk_commit_hash,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_app_summary_records_without_preload_content(
        self,
        stack: StrictStr,
        application_name: StrictStr,
        branch: list[StrictStr | None] | None = None,
        sdk_commit_hash: list[StrictStr | None] | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get App Summary Records

        Get the high-level analysis results for an app

        :param stack: (required)
        :type stack: str
        :param application_name: (required)
        :type application_name: str
        :param branch:
        :type branch: List[Optional[str]]
        :param sdk_commit_hash:
        :type sdk_commit_hash: List[Optional[str]]
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_app_summary_records_serialize(
            stack=stack,
            application_name=application_name,
            branch=branch,
            sdk_commit_hash=sdk_commit_hash,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "object",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_app_summary_records_serialize(
        self,
        stack,
        application_name,
        branch,
        sdk_commit_hash,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {
            "branch": "multi",
            "sdk_commit_hash": "multi",
        }

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        if stack is not None:
            _query_params.append(("stack", stack))

        if application_name is not None:
            _query_params.append(("application_name", application_name))

        if branch is not None:
            _query_params.append(("branch", branch))

        if sdk_commit_hash is not None:
            _query_params.append(("sdk_commit_hash", sdk_commit_hash))

        if warehouse is not None:
            _query_params.append(("warehouse", warehouse))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_app_summary_records",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_branch_builds(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> list[object]:
        """Get Branch Builds

        Get the list of all branch/build combinations

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_branch_builds_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[object]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_branch_builds_with_http_info(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[list[object]]:
        """Get Branch Builds

        Get the list of all branch/build combinations

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_branch_builds_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[object]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_branch_builds_without_preload_content(
        self,
        disable_cache: StrictBool | None = None,
        warehouse: StrictStr | None = None,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Branch Builds

        Get the list of all branch/build combinations

        :param disable_cache:
        :type disable_cache: bool
        :param warehouse:
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_branch_builds_serialize(
            disable_cache=disable_cache,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[object]",
            "422": "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_branch_builds_serialize(
        self,
        disable_cache,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        if disable_cache is not None:
            _query_params.append(("disable_cache", disable_cache))

        if warehouse is not None:
            _query_params.append(("warehouse", warehouse))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_branch_builds",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_target_info(
        self,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> list[TargetInfo]:
        """Get Target Info

        Get the list of all analyzed app names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_target_info_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[TargetInfo]",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_target_info_with_http_info(
        self,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[list[TargetInfo]]:
        """Get Target Info

        Get the list of all analyzed app names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_target_info_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[TargetInfo]",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_target_info_without_preload_content(
        self,
        _request_timeout: None
        | Annotated[StrictFloat, Field(gt=0)]
        | tuple[
            Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
        ] = None,
        _request_auth: dict[StrictStr, Any] | None = None,
        _content_type: StrictStr | None = None,
        _headers: dict[StrictStr, Any] | None = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Target Info

        Get the list of all analyzed app names

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_target_info_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: dict[str, str | None] = {
            "200": "List[TargetInfo]",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_target_info_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: dict[str, str] = {}

        _path_params: dict[str, str] = {}
        _query_params: list[tuple[str, str]] = []
        _header_params: dict[str, str | None] = _headers or {}
        _form_params: list[tuple[str, str]] = []
        _files: dict[
            str, str | bytes | list[str] | list[bytes] | list[tuple[str, bytes]]
        ] = {}
        _body_params: bytes | None = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json"]
            )

        # authentication setting
        _auth_settings: list[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/results/get_target_info",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
