from django.conf import settings

API_FALLBACK_VERSION = 'fallback'
API_FALLBACK_FOR_APPLICATION_JSON_ONLY = False
API_DEFAULT_VERSION = 'default'
API_DEFAULT_FORMAT = 'full'
API_PREFIXES = ('/api',)
API_FORMATS = ('full',)

API_RESOURCE_DISCRIMINATIVE_PARAM = 'view_type'
API_RESOURCE_DEFAULT = 'default'
API_RESOURCE_SET_PARAM = False
API_RESOURCE_SET_PARAM_FOR_DEFAULT = False

API_VERSIONS = {
    API_FALLBACK_VERSION: settings.ROOT_URLCONF,
    API_DEFAULT_VERSION: settings.ROOT_URLCONF,
}

API_ENABLE_STRUCTLOG = getattr(settings, 'ENABLE_STRUCTLOG', False)
