import { IBucket } from '@aws-cdk/aws-s3';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) A Firewall Domain List.
 *
 * @experimental
 */
export interface IFirewallDomainList extends IResource {
    /**
     * (experimental) The ID of the domain list.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListId: string;
}
/**
 * (experimental) Properties for a Firewall Domain List.
 *
 * @experimental
 */
export interface FirewallDomainListProps {
    /**
     * (experimental) A name for the domain list.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) A list of domains.
     *
     * @experimental
     */
    readonly domains: FirewallDomains;
}
/**
 * (experimental) A list of domains.
 *
 * @experimental
 */
export declare abstract class FirewallDomains {
    /**
     * (experimental) Firewall domains created from a list of domains.
     *
     * @param list the list of domains.
     * @experimental
     */
    static fromList(list: string[]): FirewallDomains;
    /**
     * (experimental) Firewall domains created from the URL of a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param url S3 bucket url (s3://bucket/prefix/objet).
     * @experimental
     */
    static fromS3Url(url: string): FirewallDomains;
    /**
     * (experimental) Firewall domains created from a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param bucket S3 bucket.
     * @param key S3 key.
     * @experimental
     */
    static fromS3(bucket: IBucket, key: string): FirewallDomains;
    /**
     * (experimental) Firewall domains created from a local disk path to a text file.
     *
     * The file must be a text file (`.txt` extension) and must contain a single
     * domain per line. It will be uploaded to S3.
     *
     * @param assetPath path to the text file.
     * @experimental
     */
    static fromAsset(assetPath: string): FirewallDomains;
    /**
     * (experimental) Binds the domains to a domain list.
     *
     * @experimental
     */
    abstract bind(scope: Construct): DomainsConfig;
}
/**
 * (experimental) Domains configuration.
 *
 * @experimental
 */
export interface DomainsConfig {
    /**
     * (experimental) The fully qualified URL or URI of the file stored in Amazon S3 that contains the list of domains to import.
     *
     * The file must be a text file and must contain
     * a single domain per line. The content type of the S3 object must be `plain/text`.
     *
     * @default - use `domains`
     * @experimental
     */
    readonly domainFileUrl?: string;
    /**
     * (experimental) A list of domains.
     *
     * @default - use `domainFileUrl`
     * @experimental
     */
    readonly domains?: string[];
}
/**
 * (experimental) A Firewall Domain List.
 *
 * @experimental
 */
export declare class FirewallDomainList extends Resource implements IFirewallDomainList {
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallDomainListId(scope: Construct, id: string, firewallDomainListId: string): IFirewallDomainList;
    /**
     * (experimental) The ID of the domain list.
     *
     * @experimental
     */
    readonly firewallDomainListId: string;
    /**
     * (experimental) The ARN (Amazon Resource Name) of the domain list.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListArn: string;
    /**
     * (experimental) The date and time that the domain list was created.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListCreationTime: string;
    /**
     * (experimental) The creator request ID.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListCreatorRequestId: string;
    /**
     * (experimental) The number of domains in the list.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListDomainCount: number;
    /**
     * (experimental) The owner of the list, used only for lists that are not managed by you.
     *
     * For example, the managed domain list `AWSManagedDomainsMalwareDomainList`
     * has the managed owner name `Route 53 Resolver DNS Firewall`.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListManagedOwnerName: string;
    /**
     * (experimental) The date and time that the domain list was last modified.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListModificationTime: string;
    /**
     * (experimental) The status of the domain list.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListStatus: string;
    /**
     * (experimental) Additional information about the status of the rule group.
     *
     * @experimental
     * @attribute true
     */
    readonly firewallDomainListStatusMessage: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FirewallDomainListProps);
}
