"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroupAssociation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * (experimental) A Firewall Rule Group Association.
 *
 * @experimental
 */
class FirewallRuleGroupAssociation extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (!core_1.Token.isUnresolved(props.priority) && (props.priority <= 100 || props.priority >= 9000)) {
            throw new Error(`Priority must be greater than 100 and less than 9000, got ${props.priority}`);
        }
        const association = new route53resolver_generated_1.CfnFirewallRuleGroupAssociation(this, 'Resource', {
            firewallRuleGroupId: props.firewallRuleGroup.firewallRuleGroupId,
            priority: props.priority,
            vpcId: props.vpc.vpcId,
        });
        this.firewallRuleGroupAssociationArn = association.attrArn;
        this.firewallRuleGroupAssociationCreationTime = association.attrCreationTime;
        this.firewallRuleGroupAssociationCreatorRequestId = association.attrCreatorRequestId;
        this.firewallRuleGroupAssociationId = association.attrId;
        this.firewallRuleGroupAssociationManagedOwnerName = association.attrManagedOwnerName;
        this.firewallRuleGroupAssociationModificationTime = association.attrModificationTime;
        this.firewallRuleGroupAssociationStatus = association.attrStatus;
        this.firewallRuleGroupAssociationStatusMessage = association.attrStatusMessage;
    }
}
exports.FirewallRuleGroupAssociation = FirewallRuleGroupAssociation;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleGroupAssociation[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroupAssociation", version: "1.126.0" };
//# sourceMappingURL=data:application/json;base64,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