# Find MLX
#
# Defines the following variables:
#
#   MLX_FOUND            : True if MLX is found
#   MLX_INCLUDE_DIRS     : Include directory
#   MLX_LIBRARIES        : Libraries to link against
#   MLX_CXX_FLAGS        : Additional compiler flags
#   MLX_BUILD_ACCELERATE : True if MLX was built with accelerate 
#   MLX_BUILD_METAL      : True if MLX was built with metal 


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was mlx.pc.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

include(${PACKAGE_PREFIX_DIR}/share/cmake/MLX/MLXTargets.cmake)
include(${PACKAGE_PREFIX_DIR}/share/cmake/MLX/extension.cmake)

set_and_check(MLX_LIBRARY_DIRS ${PACKAGE_PREFIX_DIR}/lib)
set_and_check(MLX_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/include)
set(MLX_LIBRARIES mlx)

find_library(MLX_LIBRARY mlx PATHS ${MLX_LIBRARY_DIRS})

if (ON)
    set(MLX_BUILD_ACCELERATE ON)
    set(MLX_CXX_FLAGS ${MLX_CXX_FLAGS} -DACCELERATE_NEW_LAPACK)
endif()

if (ON)
    set(MLX_BUILD_METAL ON)
    set(MLX_CXX_FLAGS ${MLX_CXX_FLAGS} -D_METAL_)
    set(MLX_INCLUDE_DIRS 
        "${MLX_INCLUDE_DIRS};"
        ${PACKAGE_PREFIX_DIR}/include/metal_cpp
    )
    if(320 GREATER_EQUAL 310)
      set(MLX_INCLUDE_DIRS
        "${MLX_INCLUDE_DIRS};"
        ${PACKAGE_PREFIX_DIR}/include/mlx/backend/metal/kernels/metal_3_1)
    else()
      set(MLX_INCLUDE_DIRS
        "${MLX_INCLUDE_DIRS};"
        ${PACKAGE_PREFIX_DIR}/include/mlx/backend/metal/kernels/metal_3_0)
    endif()
endif()

set_target_properties(mlx PROPERTIES
    CXX_STANDARD 17
    INTERFACE_COMPILE_OPTIONS "${MLX_CXX_FLAGS}"
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MLX DEFAULT_MSG MLX_LIBRARY MLX_INCLUDE_DIRS)
