import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceManagedCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#custom_hostname_binding_id AppServiceManagedCertificate#custom_hostname_binding_id}
    */
    readonly customHostnameBindingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#tags AppServiceManagedCertificate#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#timeouts AppServiceManagedCertificate#timeouts}
    */
    readonly timeouts?: AppServiceManagedCertificateTimeouts;
}
export interface AppServiceManagedCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#create AppServiceManagedCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#delete AppServiceManagedCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#read AppServiceManagedCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate#update AppServiceManagedCertificate#update}
    */
    readonly update?: string;
}
export declare function appServiceManagedCertificateTimeoutsToTerraform(struct?: AppServiceManagedCertificateTimeoutsOutputReference | AppServiceManagedCertificateTimeouts | cdktf.IResolvable): any;
export declare class AppServiceManagedCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppServiceManagedCertificateTimeouts | undefined;
    set internalValue(value: AppServiceManagedCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate azurerm_app_service_managed_certificate}
*/
export declare class AppServiceManagedCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_managed_certificate azurerm_app_service_managed_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceManagedCertificateConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceManagedCertificateConfig);
    get canonicalName(): string;
    private _customHostnameBindingId?;
    get customHostnameBindingId(): string;
    set customHostnameBindingId(value: string);
    get customHostnameBindingIdInput(): string | undefined;
    get expirationDate(): string;
    get friendlyName(): string;
    get hostNames(): string[];
    get id(): string;
    get issueDate(): string;
    get issuer(): string;
    get subjectName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): AppServiceManagedCertificateTimeoutsOutputReference;
    putTimeouts(value: AppServiceManagedCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceManagedCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
