import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationJobScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#automation_account_name AutomationJobSchedule#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#job_schedule_id AutomationJobSchedule#job_schedule_id}
    */
    readonly jobScheduleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#parameters AutomationJobSchedule#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#resource_group_name AutomationJobSchedule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#run_on AutomationJobSchedule#run_on}
    */
    readonly runOn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#runbook_name AutomationJobSchedule#runbook_name}
    */
    readonly runbookName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#schedule_name AutomationJobSchedule#schedule_name}
    */
    readonly scheduleName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#timeouts AutomationJobSchedule#timeouts}
    */
    readonly timeouts?: AutomationJobScheduleTimeouts;
}
export interface AutomationJobScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#create AutomationJobSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#delete AutomationJobSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#read AutomationJobSchedule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule#update AutomationJobSchedule#update}
    */
    readonly update?: string;
}
export declare function automationJobScheduleTimeoutsToTerraform(struct?: AutomationJobScheduleTimeoutsOutputReference | AutomationJobScheduleTimeouts | cdktf.IResolvable): any;
export declare class AutomationJobScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AutomationJobScheduleTimeouts | undefined;
    set internalValue(value: AutomationJobScheduleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule azurerm_automation_job_schedule}
*/
export declare class AutomationJobSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_job_schedule azurerm_automation_job_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationJobScheduleConfig
    */
    constructor(scope: Construct, id: string, config: AutomationJobScheduleConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    get id(): string;
    private _jobScheduleId?;
    get jobScheduleId(): string;
    set jobScheduleId(value: string);
    resetJobScheduleId(): void;
    get jobScheduleIdInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _runOn?;
    get runOn(): string;
    set runOn(value: string);
    resetRunOn(): void;
    get runOnInput(): string | undefined;
    private _runbookName?;
    get runbookName(): string;
    set runbookName(value: string);
    get runbookNameInput(): string | undefined;
    private _scheduleName?;
    get scheduleName(): string;
    set scheduleName(value: string);
    get scheduleNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): AutomationJobScheduleTimeoutsOutputReference;
    putTimeouts(value: AutomationJobScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AutomationJobScheduleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
