import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveAccountCustomerManagedKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#cognitive_account_id CognitiveAccountCustomerManagedKey#cognitive_account_id}
    */
    readonly cognitiveAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#identity_client_id CognitiveAccountCustomerManagedKey#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#key_vault_key_id CognitiveAccountCustomerManagedKey#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#timeouts CognitiveAccountCustomerManagedKey#timeouts}
    */
    readonly timeouts?: CognitiveAccountCustomerManagedKeyTimeouts;
}
export interface CognitiveAccountCustomerManagedKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#create CognitiveAccountCustomerManagedKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#delete CognitiveAccountCustomerManagedKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#read CognitiveAccountCustomerManagedKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key#update CognitiveAccountCustomerManagedKey#update}
    */
    readonly update?: string;
}
export declare function cognitiveAccountCustomerManagedKeyTimeoutsToTerraform(struct?: CognitiveAccountCustomerManagedKeyTimeoutsOutputReference | CognitiveAccountCustomerManagedKeyTimeouts | cdktf.IResolvable): any;
export declare class CognitiveAccountCustomerManagedKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CognitiveAccountCustomerManagedKeyTimeouts | undefined;
    set internalValue(value: CognitiveAccountCustomerManagedKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key azurerm_cognitive_account_customer_managed_key}
*/
export declare class CognitiveAccountCustomerManagedKey extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account_customer_managed_key azurerm_cognitive_account_customer_managed_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveAccountCustomerManagedKeyConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveAccountCustomerManagedKeyConfig);
    private _cognitiveAccountId?;
    get cognitiveAccountId(): string;
    set cognitiveAccountId(value: string);
    get cognitiveAccountIdInput(): string | undefined;
    get id(): string;
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): CognitiveAccountCustomerManagedKeyTimeoutsOutputReference;
    putTimeouts(value: CognitiveAccountCustomerManagedKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CognitiveAccountCustomerManagedKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
