import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsumptionBudgetManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#amount ConsumptionBudgetManagementGroup#amount}
    */
    readonly amount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#etag ConsumptionBudgetManagementGroup#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#management_group_id ConsumptionBudgetManagementGroup#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#time_grain ConsumptionBudgetManagementGroup#time_grain}
    */
    readonly timeGrain?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#filter ConsumptionBudgetManagementGroup#filter}
    */
    readonly filter?: ConsumptionBudgetManagementGroupFilter;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#notification ConsumptionBudgetManagementGroup#notification}
    */
    readonly notification: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#time_period ConsumptionBudgetManagementGroup#time_period}
    */
    readonly timePeriod: ConsumptionBudgetManagementGroupTimePeriod;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#timeouts ConsumptionBudgetManagementGroup#timeouts}
    */
    readonly timeouts?: ConsumptionBudgetManagementGroupTimeouts;
}
export interface ConsumptionBudgetManagementGroupFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterDimension | cdktf.IResolvable): any;
export interface ConsumptionBudgetManagementGroupFilterNotDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotDimensionToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference | ConsumptionBudgetManagementGroupFilterNotDimension): any;
export declare class ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotDimension | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterNotTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterNotTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotTagOutputReference | ConsumptionBudgetManagementGroupFilterNotTag): any;
export declare class ConsumptionBudgetManagementGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNotTag | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterNot {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterNotDimension;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
    */
    readonly tag?: ConsumptionBudgetManagementGroupFilterNotTag;
}
export declare function consumptionBudgetManagementGroupFilterNotToTerraform(struct?: ConsumptionBudgetManagementGroupFilterNotOutputReference | ConsumptionBudgetManagementGroupFilterNot): any;
export declare class ConsumptionBudgetManagementGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilterNot | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetManagementGroupFilterNotDimensionOutputReference;
    putDimension(value: ConsumptionBudgetManagementGroupFilterNotDimension): void;
    resetDimension(): void;
    get dimensionInput(): ConsumptionBudgetManagementGroupFilterNotDimension | undefined;
    private _tag;
    get tag(): ConsumptionBudgetManagementGroupFilterNotTagOutputReference;
    putTag(value: ConsumptionBudgetManagementGroupFilterNotTag): void;
    resetTag(): void;
    get tagInput(): ConsumptionBudgetManagementGroupFilterNotTag | undefined;
}
export interface ConsumptionBudgetManagementGroupFilterTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#name ConsumptionBudgetManagementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#values ConsumptionBudgetManagementGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetManagementGroupFilterTagToTerraform(struct?: ConsumptionBudgetManagementGroupFilterTag | cdktf.IResolvable): any;
export interface ConsumptionBudgetManagementGroupFilter {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#dimension ConsumptionBudgetManagementGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * not block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#not ConsumptionBudgetManagementGroup#not}
    */
    readonly not?: ConsumptionBudgetManagementGroupFilterNot;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#tag ConsumptionBudgetManagementGroup#tag}
    */
    readonly tag?: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetManagementGroupFilterToTerraform(struct?: ConsumptionBudgetManagementGroupFilterOutputReference | ConsumptionBudgetManagementGroupFilter): any;
export declare class ConsumptionBudgetManagementGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupFilter | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupFilter | undefined);
    private _dimension?;
    get dimension(): ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable;
    set dimension(value: ConsumptionBudgetManagementGroupFilterDimension[] | cdktf.IResolvable);
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterDimension[] | undefined;
    private _not;
    get not(): ConsumptionBudgetManagementGroupFilterNotOutputReference;
    putNot(value: ConsumptionBudgetManagementGroupFilterNot): void;
    resetNot(): void;
    get notInput(): ConsumptionBudgetManagementGroupFilterNot | undefined;
    private _tag?;
    get tag(): ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable;
    set tag(value: ConsumptionBudgetManagementGroupFilterTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupFilterTag[] | undefined;
}
export interface ConsumptionBudgetManagementGroupNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#contact_emails ConsumptionBudgetManagementGroup#contact_emails}
    */
    readonly contactEmails: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#enabled ConsumptionBudgetManagementGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#operator ConsumptionBudgetManagementGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#threshold ConsumptionBudgetManagementGroup#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#threshold_type ConsumptionBudgetManagementGroup#threshold_type}
    */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetManagementGroupNotificationToTerraform(struct?: ConsumptionBudgetManagementGroupNotification | cdktf.IResolvable): any;
export interface ConsumptionBudgetManagementGroupTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#end_date ConsumptionBudgetManagementGroup#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#start_date ConsumptionBudgetManagementGroup#start_date}
    */
    readonly startDate: string;
}
export declare function consumptionBudgetManagementGroupTimePeriodToTerraform(struct?: ConsumptionBudgetManagementGroupTimePeriodOutputReference | ConsumptionBudgetManagementGroupTimePeriod): any;
export declare class ConsumptionBudgetManagementGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupTimePeriod | undefined);
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
}
export interface ConsumptionBudgetManagementGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#create ConsumptionBudgetManagementGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#delete ConsumptionBudgetManagementGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#read ConsumptionBudgetManagementGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group#update ConsumptionBudgetManagementGroup#update}
    */
    readonly update?: string;
}
export declare function consumptionBudgetManagementGroupTimeoutsToTerraform(struct?: ConsumptionBudgetManagementGroupTimeoutsOutputReference | ConsumptionBudgetManagementGroupTimeouts | cdktf.IResolvable): any;
export declare class ConsumptionBudgetManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ConsumptionBudgetManagementGroupTimeouts | undefined;
    set internalValue(value: ConsumptionBudgetManagementGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group azurerm_consumption_budget_management_group}
*/
export declare class ConsumptionBudgetManagementGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_management_group azurerm_consumption_budget_management_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsumptionBudgetManagementGroupConfig
    */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetManagementGroupConfig);
    private _amount?;
    get amount(): number;
    set amount(value: number);
    get amountInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    get id(): string;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    resetTimeGrain(): void;
    get timeGrainInput(): string | undefined;
    private _filter;
    get filter(): ConsumptionBudgetManagementGroupFilterOutputReference;
    putFilter(value: ConsumptionBudgetManagementGroupFilter): void;
    resetFilter(): void;
    get filterInput(): ConsumptionBudgetManagementGroupFilter | undefined;
    private _notification?;
    get notification(): ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable;
    set notification(value: ConsumptionBudgetManagementGroupNotification[] | cdktf.IResolvable);
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetManagementGroupNotification[] | undefined;
    private _timePeriod;
    get timePeriod(): ConsumptionBudgetManagementGroupTimePeriodOutputReference;
    putTimePeriod(value: ConsumptionBudgetManagementGroupTimePeriod): void;
    get timePeriodInput(): ConsumptionBudgetManagementGroupTimePeriod | undefined;
    private _timeouts;
    get timeouts(): ConsumptionBudgetManagementGroupTimeoutsOutputReference;
    putTimeouts(value: ConsumptionBudgetManagementGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ConsumptionBudgetManagementGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
