import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbCassandraTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#analytical_storage_ttl CosmosdbCassandraTable#analytical_storage_ttl}
    */
    readonly analyticalStorageTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#cassandra_keyspace_id CosmosdbCassandraTable#cassandra_keyspace_id}
    */
    readonly cassandraKeyspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#default_ttl CosmosdbCassandraTable#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#throughput CosmosdbCassandraTable#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#autoscale_settings CosmosdbCassandraTable#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbCassandraTableAutoscaleSettings;
    /**
    * schema block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#schema CosmosdbCassandraTable#schema}
    */
    readonly schema: CosmosdbCassandraTableSchema;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#timeouts CosmosdbCassandraTable#timeouts}
    */
    readonly timeouts?: CosmosdbCassandraTableTimeouts;
}
export interface CosmosdbCassandraTableAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#max_throughput CosmosdbCassandraTable#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbCassandraTableAutoscaleSettingsToTerraform(struct?: CosmosdbCassandraTableAutoscaleSettingsOutputReference | CosmosdbCassandraTableAutoscaleSettings): any;
export declare class CosmosdbCassandraTableAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbCassandraTableAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbCassandraTableSchemaClusterKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#order_by CosmosdbCassandraTable#order_by}
    */
    readonly orderBy: string;
}
export declare function cosmosdbCassandraTableSchemaClusterKeyToTerraform(struct?: CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable): any;
export interface CosmosdbCassandraTableSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#type CosmosdbCassandraTable#type}
    */
    readonly type: string;
}
export declare function cosmosdbCassandraTableSchemaColumnToTerraform(struct?: CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable): any;
export interface CosmosdbCassandraTableSchemaPartitionKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
}
export declare function cosmosdbCassandraTableSchemaPartitionKeyToTerraform(struct?: CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable): any;
export interface CosmosdbCassandraTableSchema {
    /**
    * cluster_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#cluster_key CosmosdbCassandraTable#cluster_key}
    */
    readonly clusterKey?: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#column CosmosdbCassandraTable#column}
    */
    readonly column: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    /**
    * partition_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#partition_key CosmosdbCassandraTable#partition_key}
    */
    readonly partitionKey: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
}
export declare function cosmosdbCassandraTableSchemaToTerraform(struct?: CosmosdbCassandraTableSchemaOutputReference | CosmosdbCassandraTableSchema): any;
export declare class CosmosdbCassandraTableSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbCassandraTableSchema | undefined;
    set internalValue(value: CosmosdbCassandraTableSchema | undefined);
    private _clusterKey?;
    get clusterKey(): CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    set clusterKey(value: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable);
    resetClusterKey(): void;
    get clusterKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaClusterKey[] | undefined;
    private _column?;
    get column(): CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    set column(value: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable);
    get columnInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaColumn[] | undefined;
    private _partitionKey?;
    get partitionKey(): CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
    set partitionKey(value: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable);
    get partitionKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaPartitionKey[] | undefined;
}
export interface CosmosdbCassandraTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#create CosmosdbCassandraTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#delete CosmosdbCassandraTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#read CosmosdbCassandraTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table#update CosmosdbCassandraTable#update}
    */
    readonly update?: string;
}
export declare function cosmosdbCassandraTableTimeoutsToTerraform(struct?: CosmosdbCassandraTableTimeoutsOutputReference | CosmosdbCassandraTableTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbCassandraTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbCassandraTableTimeouts | undefined;
    set internalValue(value: CosmosdbCassandraTableTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table}
*/
export declare class CosmosdbCassandraTable extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbCassandraTableConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraTableConfig);
    private _analyticalStorageTtl?;
    get analyticalStorageTtl(): number;
    set analyticalStorageTtl(value: number);
    resetAnalyticalStorageTtl(): void;
    get analyticalStorageTtlInput(): number | undefined;
    private _cassandraKeyspaceId?;
    get cassandraKeyspaceId(): string;
    set cassandraKeyspaceId(value: string);
    get cassandraKeyspaceIdInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbCassandraTableAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbCassandraTableAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    private _schema;
    get schema(): CosmosdbCassandraTableSchemaOutputReference;
    putSchema(value: CosmosdbCassandraTableSchema): void;
    get schemaInput(): CosmosdbCassandraTableSchema | undefined;
    private _timeouts;
    get timeouts(): CosmosdbCassandraTableTimeoutsOutputReference;
    putTimeouts(value: CosmosdbCassandraTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CosmosdbCassandraTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
