import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbGremlinGraphConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#account_name CosmosdbGremlinGraph#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#database_name CosmosdbGremlinGraph#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#default_ttl CosmosdbGremlinGraph#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#name CosmosdbGremlinGraph#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#partition_key_path CosmosdbGremlinGraph#partition_key_path}
    */
    readonly partitionKeyPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#partition_key_version CosmosdbGremlinGraph#partition_key_version}
    */
    readonly partitionKeyVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#resource_group_name CosmosdbGremlinGraph#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#throughput CosmosdbGremlinGraph#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#autoscale_settings CosmosdbGremlinGraph#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbGremlinGraphAutoscaleSettings;
    /**
    * conflict_resolution_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#conflict_resolution_policy CosmosdbGremlinGraph#conflict_resolution_policy}
    */
    readonly conflictResolutionPolicy?: CosmosdbGremlinGraphConflictResolutionPolicy;
    /**
    * index_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#index_policy CosmosdbGremlinGraph#index_policy}
    */
    readonly indexPolicy?: CosmosdbGremlinGraphIndexPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#timeouts CosmosdbGremlinGraph#timeouts}
    */
    readonly timeouts?: CosmosdbGremlinGraphTimeouts;
    /**
    * unique_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#unique_key CosmosdbGremlinGraph#unique_key}
    */
    readonly uniqueKey?: CosmosdbGremlinGraphUniqueKey[] | cdktf.IResolvable;
}
export interface CosmosdbGremlinGraphAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#max_throughput CosmosdbGremlinGraph#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbGremlinGraphAutoscaleSettingsToTerraform(struct?: CosmosdbGremlinGraphAutoscaleSettingsOutputReference | CosmosdbGremlinGraphAutoscaleSettings): any;
export declare class CosmosdbGremlinGraphAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbGremlinGraphAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbGremlinGraphAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbGremlinGraphConflictResolutionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#conflict_resolution_path CosmosdbGremlinGraph#conflict_resolution_path}
    */
    readonly conflictResolutionPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#conflict_resolution_procedure CosmosdbGremlinGraph#conflict_resolution_procedure}
    */
    readonly conflictResolutionProcedure?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#mode CosmosdbGremlinGraph#mode}
    */
    readonly mode: string;
}
export declare function cosmosdbGremlinGraphConflictResolutionPolicyToTerraform(struct?: CosmosdbGremlinGraphConflictResolutionPolicyOutputReference | CosmosdbGremlinGraphConflictResolutionPolicy): any;
export declare class CosmosdbGremlinGraphConflictResolutionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbGremlinGraphConflictResolutionPolicy | undefined;
    set internalValue(value: CosmosdbGremlinGraphConflictResolutionPolicy | undefined);
    private _conflictResolutionPath?;
    get conflictResolutionPath(): string;
    set conflictResolutionPath(value: string);
    resetConflictResolutionPath(): void;
    get conflictResolutionPathInput(): string | undefined;
    private _conflictResolutionProcedure?;
    get conflictResolutionProcedure(): string;
    set conflictResolutionProcedure(value: string);
    resetConflictResolutionProcedure(): void;
    get conflictResolutionProcedureInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#order CosmosdbGremlinGraph#order}
    */
    readonly order: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#path CosmosdbGremlinGraph#path}
    */
    readonly path: string;
}
export declare function cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex | cdktf.IResolvable): any;
export interface CosmosdbGremlinGraphIndexPolicyCompositeIndex {
    /**
    * index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#index CosmosdbGremlinGraph#index}
    */
    readonly index: CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex[] | cdktf.IResolvable;
}
export declare function cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyCompositeIndex | cdktf.IResolvable): any;
export interface CosmosdbGremlinGraphIndexPolicySpatialIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#path CosmosdbGremlinGraph#path}
    */
    readonly path: string;
}
export declare function cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicySpatialIndex | cdktf.IResolvable): any;
export interface CosmosdbGremlinGraphIndexPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#automatic CosmosdbGremlinGraph#automatic}
    */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#excluded_paths CosmosdbGremlinGraph#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#included_paths CosmosdbGremlinGraph#included_paths}
    */
    readonly includedPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#indexing_mode CosmosdbGremlinGraph#indexing_mode}
    */
    readonly indexingMode: string;
    /**
    * composite_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#composite_index CosmosdbGremlinGraph#composite_index}
    */
    readonly compositeIndex?: CosmosdbGremlinGraphIndexPolicyCompositeIndex[] | cdktf.IResolvable;
    /**
    * spatial_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#spatial_index CosmosdbGremlinGraph#spatial_index}
    */
    readonly spatialIndex?: CosmosdbGremlinGraphIndexPolicySpatialIndex[] | cdktf.IResolvable;
}
export declare function cosmosdbGremlinGraphIndexPolicyToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyOutputReference | CosmosdbGremlinGraphIndexPolicy): any;
export declare class CosmosdbGremlinGraphIndexPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbGremlinGraphIndexPolicy | undefined;
    set internalValue(value: CosmosdbGremlinGraphIndexPolicy | undefined);
    private _automatic?;
    get automatic(): boolean | cdktf.IResolvable;
    set automatic(value: boolean | cdktf.IResolvable);
    resetAutomatic(): void;
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _includedPaths?;
    get includedPaths(): string[];
    set includedPaths(value: string[]);
    resetIncludedPaths(): void;
    get includedPathsInput(): string[] | undefined;
    private _indexingMode?;
    get indexingMode(): string;
    set indexingMode(value: string);
    get indexingModeInput(): string | undefined;
    private _compositeIndex?;
    get compositeIndex(): CosmosdbGremlinGraphIndexPolicyCompositeIndex[] | cdktf.IResolvable;
    set compositeIndex(value: CosmosdbGremlinGraphIndexPolicyCompositeIndex[] | cdktf.IResolvable);
    resetCompositeIndex(): void;
    get compositeIndexInput(): cdktf.IResolvable | CosmosdbGremlinGraphIndexPolicyCompositeIndex[] | undefined;
    private _spatialIndex?;
    get spatialIndex(): CosmosdbGremlinGraphIndexPolicySpatialIndex[] | cdktf.IResolvable;
    set spatialIndex(value: CosmosdbGremlinGraphIndexPolicySpatialIndex[] | cdktf.IResolvable);
    resetSpatialIndex(): void;
    get spatialIndexInput(): cdktf.IResolvable | CosmosdbGremlinGraphIndexPolicySpatialIndex[] | undefined;
}
export interface CosmosdbGremlinGraphTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#create CosmosdbGremlinGraph#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#delete CosmosdbGremlinGraph#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#read CosmosdbGremlinGraph#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#update CosmosdbGremlinGraph#update}
    */
    readonly update?: string;
}
export declare function cosmosdbGremlinGraphTimeoutsToTerraform(struct?: CosmosdbGremlinGraphTimeoutsOutputReference | CosmosdbGremlinGraphTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbGremlinGraphTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbGremlinGraphTimeouts | undefined;
    set internalValue(value: CosmosdbGremlinGraphTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CosmosdbGremlinGraphUniqueKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph#paths CosmosdbGremlinGraph#paths}
    */
    readonly paths: string[];
}
export declare function cosmosdbGremlinGraphUniqueKeyToTerraform(struct?: CosmosdbGremlinGraphUniqueKey | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph azurerm_cosmosdb_gremlin_graph}
*/
export declare class CosmosdbGremlinGraph extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph azurerm_cosmosdb_gremlin_graph} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbGremlinGraphConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbGremlinGraphConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partitionKeyPath?;
    get partitionKeyPath(): string;
    set partitionKeyPath(value: string);
    get partitionKeyPathInput(): string | undefined;
    private _partitionKeyVersion?;
    get partitionKeyVersion(): number;
    set partitionKeyVersion(value: number);
    resetPartitionKeyVersion(): void;
    get partitionKeyVersionInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbGremlinGraphAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbGremlinGraphAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbGremlinGraphAutoscaleSettings | undefined;
    private _conflictResolutionPolicy;
    get conflictResolutionPolicy(): CosmosdbGremlinGraphConflictResolutionPolicyOutputReference;
    putConflictResolutionPolicy(value: CosmosdbGremlinGraphConflictResolutionPolicy): void;
    resetConflictResolutionPolicy(): void;
    get conflictResolutionPolicyInput(): CosmosdbGremlinGraphConflictResolutionPolicy | undefined;
    private _indexPolicy;
    get indexPolicy(): CosmosdbGremlinGraphIndexPolicyOutputReference;
    putIndexPolicy(value: CosmosdbGremlinGraphIndexPolicy): void;
    resetIndexPolicy(): void;
    get indexPolicyInput(): CosmosdbGremlinGraphIndexPolicy | undefined;
    private _timeouts;
    get timeouts(): CosmosdbGremlinGraphTimeoutsOutputReference;
    putTimeouts(value: CosmosdbGremlinGraphTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CosmosdbGremlinGraphTimeouts | undefined;
    private _uniqueKey?;
    get uniqueKey(): CosmosdbGremlinGraphUniqueKey[] | cdktf.IResolvable;
    set uniqueKey(value: CosmosdbGremlinGraphUniqueKey[] | cdktf.IResolvable);
    resetUniqueKey(): void;
    get uniqueKeyInput(): cdktf.IResolvable | CosmosdbGremlinGraphUniqueKey[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
