"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CosmosdbGremlinGraph = exports.cosmosdbGremlinGraphUniqueKeyToTerraform = exports.CosmosdbGremlinGraphTimeoutsOutputReference = exports.cosmosdbGremlinGraphTimeoutsToTerraform = exports.CosmosdbGremlinGraphIndexPolicyOutputReference = exports.cosmosdbGremlinGraphIndexPolicyToTerraform = exports.cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform = exports.cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform = exports.cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform = exports.CosmosdbGremlinGraphConflictResolutionPolicyOutputReference = exports.cosmosdbGremlinGraphConflictResolutionPolicyToTerraform = exports.CosmosdbGremlinGraphAutoscaleSettingsOutputReference = exports.cosmosdbGremlinGraphAutoscaleSettingsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function cosmosdbGremlinGraphAutoscaleSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_throughput: cdktf.numberToTerraform(struct.maxThroughput),
    };
}
exports.cosmosdbGremlinGraphAutoscaleSettingsToTerraform = cosmosdbGremlinGraphAutoscaleSettingsToTerraform;
class CosmosdbGremlinGraphAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxThroughput !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxThroughput = this._maxThroughput;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxThroughput = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxThroughput = value.maxThroughput;
        }
    }
    get maxThroughput() {
        return this.getNumberAttribute('max_throughput');
    }
    set maxThroughput(value) {
        this._maxThroughput = value;
    }
    resetMaxThroughput() {
        this._maxThroughput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxThroughputInput() {
        return this._maxThroughput;
    }
}
exports.CosmosdbGremlinGraphAutoscaleSettingsOutputReference = CosmosdbGremlinGraphAutoscaleSettingsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
CosmosdbGremlinGraphAutoscaleSettingsOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.CosmosdbGremlinGraphAutoscaleSettingsOutputReference", version: "0.5.60" };
function cosmosdbGremlinGraphConflictResolutionPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        conflict_resolution_path: cdktf.stringToTerraform(struct.conflictResolutionPath),
        conflict_resolution_procedure: cdktf.stringToTerraform(struct.conflictResolutionProcedure),
        mode: cdktf.stringToTerraform(struct.mode),
    };
}
exports.cosmosdbGremlinGraphConflictResolutionPolicyToTerraform = cosmosdbGremlinGraphConflictResolutionPolicyToTerraform;
class CosmosdbGremlinGraphConflictResolutionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._conflictResolutionPath !== undefined) {
            hasAnyValues = true;
            internalValueResult.conflictResolutionPath = this._conflictResolutionPath;
        }
        if (this._conflictResolutionProcedure !== undefined) {
            hasAnyValues = true;
            internalValueResult.conflictResolutionProcedure = this._conflictResolutionProcedure;
        }
        if (this._mode !== undefined) {
            hasAnyValues = true;
            internalValueResult.mode = this._mode;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._conflictResolutionPath = undefined;
            this._conflictResolutionProcedure = undefined;
            this._mode = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._conflictResolutionPath = value.conflictResolutionPath;
            this._conflictResolutionProcedure = value.conflictResolutionProcedure;
            this._mode = value.mode;
        }
    }
    get conflictResolutionPath() {
        return this.getStringAttribute('conflict_resolution_path');
    }
    set conflictResolutionPath(value) {
        this._conflictResolutionPath = value;
    }
    resetConflictResolutionPath() {
        this._conflictResolutionPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get conflictResolutionPathInput() {
        return this._conflictResolutionPath;
    }
    get conflictResolutionProcedure() {
        return this.getStringAttribute('conflict_resolution_procedure');
    }
    set conflictResolutionProcedure(value) {
        this._conflictResolutionProcedure = value;
    }
    resetConflictResolutionProcedure() {
        this._conflictResolutionProcedure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get conflictResolutionProcedureInput() {
        return this._conflictResolutionProcedure;
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
}
exports.CosmosdbGremlinGraphConflictResolutionPolicyOutputReference = CosmosdbGremlinGraphConflictResolutionPolicyOutputReference;
_b = JSII_RTTI_SYMBOL_1;
CosmosdbGremlinGraphConflictResolutionPolicyOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.CosmosdbGremlinGraphConflictResolutionPolicyOutputReference", version: "0.5.60" };
function cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        order: cdktf.stringToTerraform(struct.order),
        path: cdktf.stringToTerraform(struct.path),
    };
}
exports.cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform = cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform;
function cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        index: cdktf.listMapper(cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform)(struct.index),
    };
}
exports.cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform = cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform;
function cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        path: cdktf.stringToTerraform(struct.path),
    };
}
exports.cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform = cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform;
function cosmosdbGremlinGraphIndexPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        automatic: cdktf.booleanToTerraform(struct.automatic),
        excluded_paths: cdktf.listMapper(cdktf.stringToTerraform)(struct.excludedPaths),
        included_paths: cdktf.listMapper(cdktf.stringToTerraform)(struct.includedPaths),
        indexing_mode: cdktf.stringToTerraform(struct.indexingMode),
        composite_index: cdktf.listMapper(cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform)(struct.compositeIndex),
        spatial_index: cdktf.listMapper(cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform)(struct.spatialIndex),
    };
}
exports.cosmosdbGremlinGraphIndexPolicyToTerraform = cosmosdbGremlinGraphIndexPolicyToTerraform;
class CosmosdbGremlinGraphIndexPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._automatic !== undefined) {
            hasAnyValues = true;
            internalValueResult.automatic = this._automatic;
        }
        if (this._excludedPaths !== undefined) {
            hasAnyValues = true;
            internalValueResult.excludedPaths = this._excludedPaths;
        }
        if (this._includedPaths !== undefined) {
            hasAnyValues = true;
            internalValueResult.includedPaths = this._includedPaths;
        }
        if (this._indexingMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.indexingMode = this._indexingMode;
        }
        if (this._compositeIndex !== undefined) {
            hasAnyValues = true;
            internalValueResult.compositeIndex = this._compositeIndex;
        }
        if (this._spatialIndex !== undefined) {
            hasAnyValues = true;
            internalValueResult.spatialIndex = this._spatialIndex;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._automatic = undefined;
            this._excludedPaths = undefined;
            this._includedPaths = undefined;
            this._indexingMode = undefined;
            this._compositeIndex = undefined;
            this._spatialIndex = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._automatic = value.automatic;
            this._excludedPaths = value.excludedPaths;
            this._includedPaths = value.includedPaths;
            this._indexingMode = value.indexingMode;
            this._compositeIndex = value.compositeIndex;
            this._spatialIndex = value.spatialIndex;
        }
    }
    get automatic() {
        return this.getBooleanAttribute('automatic');
    }
    set automatic(value) {
        this._automatic = value;
    }
    resetAutomatic() {
        this._automatic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get automaticInput() {
        return this._automatic;
    }
    get excludedPaths() {
        return cdktf.Fn.tolist(this.getListAttribute('excluded_paths'));
    }
    set excludedPaths(value) {
        this._excludedPaths = value;
    }
    resetExcludedPaths() {
        this._excludedPaths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludedPathsInput() {
        return this._excludedPaths;
    }
    get includedPaths() {
        return cdktf.Fn.tolist(this.getListAttribute('included_paths'));
    }
    set includedPaths(value) {
        this._includedPaths = value;
    }
    resetIncludedPaths() {
        this._includedPaths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includedPathsInput() {
        return this._includedPaths;
    }
    get indexingMode() {
        return this.getStringAttribute('indexing_mode');
    }
    set indexingMode(value) {
        this._indexingMode = value;
    }
    // Temporarily expose input value. Use with caution.
    get indexingModeInput() {
        return this._indexingMode;
    }
    get compositeIndex() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('composite_index');
    }
    set compositeIndex(value) {
        this._compositeIndex = value;
    }
    resetCompositeIndex() {
        this._compositeIndex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compositeIndexInput() {
        return this._compositeIndex;
    }
    get spatialIndex() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('spatial_index');
    }
    set spatialIndex(value) {
        this._spatialIndex = value;
    }
    resetSpatialIndex() {
        this._spatialIndex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spatialIndexInput() {
        return this._spatialIndex;
    }
}
exports.CosmosdbGremlinGraphIndexPolicyOutputReference = CosmosdbGremlinGraphIndexPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
CosmosdbGremlinGraphIndexPolicyOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.CosmosdbGremlinGraphIndexPolicyOutputReference", version: "0.5.60" };
function cosmosdbGremlinGraphTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.cosmosdbGremlinGraphTimeoutsToTerraform = cosmosdbGremlinGraphTimeoutsToTerraform;
class CosmosdbGremlinGraphTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.CosmosdbGremlinGraphTimeoutsOutputReference = CosmosdbGremlinGraphTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
CosmosdbGremlinGraphTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.CosmosdbGremlinGraphTimeoutsOutputReference", version: "0.5.60" };
function cosmosdbGremlinGraphUniqueKeyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        paths: cdktf.listMapper(cdktf.stringToTerraform)(struct.paths),
    };
}
exports.cosmosdbGremlinGraphUniqueKeyToTerraform = cosmosdbGremlinGraphUniqueKeyToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph azurerm_cosmosdb_gremlin_graph}
*/
class CosmosdbGremlinGraph extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph azurerm_cosmosdb_gremlin_graph} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbGremlinGraphConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_cosmosdb_gremlin_graph',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // autoscale_settings - computed: false, optional: true, required: false
        this._autoscaleSettings = new CosmosdbGremlinGraphAutoscaleSettingsOutputReference(this, "autoscale_settings", true);
        // conflict_resolution_policy - computed: false, optional: true, required: false
        this._conflictResolutionPolicy = new CosmosdbGremlinGraphConflictResolutionPolicyOutputReference(this, "conflict_resolution_policy", true);
        // index_policy - computed: false, optional: true, required: false
        this._indexPolicy = new CosmosdbGremlinGraphIndexPolicyOutputReference(this, "index_policy", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new CosmosdbGremlinGraphTimeoutsOutputReference(this, "timeouts", true);
        this._accountName = config.accountName;
        this._databaseName = config.databaseName;
        this._defaultTtl = config.defaultTtl;
        this._name = config.name;
        this._partitionKeyPath = config.partitionKeyPath;
        this._partitionKeyVersion = config.partitionKeyVersion;
        this._resourceGroupName = config.resourceGroupName;
        this._throughput = config.throughput;
        this._autoscaleSettings.internalValue = config.autoscaleSettings;
        this._conflictResolutionPolicy.internalValue = config.conflictResolutionPolicy;
        this._indexPolicy.internalValue = config.indexPolicy;
        this._timeouts.internalValue = config.timeouts;
        this._uniqueKey = config.uniqueKey;
    }
    get accountName() {
        return this.getStringAttribute('account_name');
    }
    set accountName(value) {
        this._accountName = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountNameInput() {
        return this._accountName;
    }
    get databaseName() {
        return this.getStringAttribute('database_name');
    }
    set databaseName(value) {
        this._databaseName = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseNameInput() {
        return this._databaseName;
    }
    get defaultTtl() {
        return this.getNumberAttribute('default_ttl');
    }
    set defaultTtl(value) {
        this._defaultTtl = value;
    }
    resetDefaultTtl() {
        this._defaultTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTtlInput() {
        return this._defaultTtl;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get partitionKeyPath() {
        return this.getStringAttribute('partition_key_path');
    }
    set partitionKeyPath(value) {
        this._partitionKeyPath = value;
    }
    // Temporarily expose input value. Use with caution.
    get partitionKeyPathInput() {
        return this._partitionKeyPath;
    }
    get partitionKeyVersion() {
        return this.getNumberAttribute('partition_key_version');
    }
    set partitionKeyVersion(value) {
        this._partitionKeyVersion = value;
    }
    resetPartitionKeyVersion() {
        this._partitionKeyVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partitionKeyVersionInput() {
        return this._partitionKeyVersion;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get throughput() {
        return this.getNumberAttribute('throughput');
    }
    set throughput(value) {
        this._throughput = value;
    }
    resetThroughput() {
        this._throughput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get throughputInput() {
        return this._throughput;
    }
    get autoscaleSettings() {
        return this._autoscaleSettings;
    }
    putAutoscaleSettings(value) {
        this._autoscaleSettings.internalValue = value;
    }
    resetAutoscaleSettings() {
        this._autoscaleSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoscaleSettingsInput() {
        return this._autoscaleSettings.internalValue;
    }
    get conflictResolutionPolicy() {
        return this._conflictResolutionPolicy;
    }
    putConflictResolutionPolicy(value) {
        this._conflictResolutionPolicy.internalValue = value;
    }
    resetConflictResolutionPolicy() {
        this._conflictResolutionPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get conflictResolutionPolicyInput() {
        return this._conflictResolutionPolicy.internalValue;
    }
    get indexPolicy() {
        return this._indexPolicy;
    }
    putIndexPolicy(value) {
        this._indexPolicy.internalValue = value;
    }
    resetIndexPolicy() {
        this._indexPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get indexPolicyInput() {
        return this._indexPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get uniqueKey() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('unique_key')));
    }
    set uniqueKey(value) {
        this._uniqueKey = value;
    }
    resetUniqueKey() {
        this._uniqueKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uniqueKeyInput() {
        return this._uniqueKey;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_name: cdktf.stringToTerraform(this._accountName),
            database_name: cdktf.stringToTerraform(this._databaseName),
            default_ttl: cdktf.numberToTerraform(this._defaultTtl),
            name: cdktf.stringToTerraform(this._name),
            partition_key_path: cdktf.stringToTerraform(this._partitionKeyPath),
            partition_key_version: cdktf.numberToTerraform(this._partitionKeyVersion),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            throughput: cdktf.numberToTerraform(this._throughput),
            autoscale_settings: cosmosdbGremlinGraphAutoscaleSettingsToTerraform(this._autoscaleSettings.internalValue),
            conflict_resolution_policy: cosmosdbGremlinGraphConflictResolutionPolicyToTerraform(this._conflictResolutionPolicy.internalValue),
            index_policy: cosmosdbGremlinGraphIndexPolicyToTerraform(this._indexPolicy.internalValue),
            timeouts: cosmosdbGremlinGraphTimeoutsToTerraform(this._timeouts.internalValue),
            unique_key: cdktf.listMapper(cosmosdbGremlinGraphUniqueKeyToTerraform)(this._uniqueKey),
        };
    }
}
exports.CosmosdbGremlinGraph = CosmosdbGremlinGraph;
_e = JSII_RTTI_SYMBOL_1;
CosmosdbGremlinGraph[_e] = { fqn: "@cdktf/provider-azurerm.CosmosdbGremlinGraph", version: "0.5.60" };
// =================
// STATIC PROPERTIES
// =================
CosmosdbGremlinGraph.tfResourceType = "azurerm_cosmosdb_gremlin_graph";
//# sourceMappingURL=data:application/json;base64,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