import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbMongoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#account_name CosmosdbMongoDatabase#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#name CosmosdbMongoDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#resource_group_name CosmosdbMongoDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#throughput CosmosdbMongoDatabase#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#autoscale_settings CosmosdbMongoDatabase#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbMongoDatabaseAutoscaleSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#timeouts CosmosdbMongoDatabase#timeouts}
    */
    readonly timeouts?: CosmosdbMongoDatabaseTimeouts;
}
export interface CosmosdbMongoDatabaseAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#max_throughput CosmosdbMongoDatabase#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbMongoDatabaseAutoscaleSettingsToTerraform(struct?: CosmosdbMongoDatabaseAutoscaleSettingsOutputReference | CosmosdbMongoDatabaseAutoscaleSettings): any;
export declare class CosmosdbMongoDatabaseAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbMongoDatabaseAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbMongoDatabaseAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbMongoDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#create CosmosdbMongoDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#delete CosmosdbMongoDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#read CosmosdbMongoDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database#update CosmosdbMongoDatabase#update}
    */
    readonly update?: string;
}
export declare function cosmosdbMongoDatabaseTimeoutsToTerraform(struct?: CosmosdbMongoDatabaseTimeoutsOutputReference | CosmosdbMongoDatabaseTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbMongoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbMongoDatabaseTimeouts | undefined;
    set internalValue(value: CosmosdbMongoDatabaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database azurerm_cosmosdb_mongo_database}
*/
export declare class CosmosdbMongoDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_database azurerm_cosmosdb_mongo_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbMongoDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbMongoDatabaseConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbMongoDatabaseAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbMongoDatabaseAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbMongoDatabaseAutoscaleSettings | undefined;
    private _timeouts;
    get timeouts(): CosmosdbMongoDatabaseTimeoutsOutputReference;
    putTimeouts(value: CosmosdbMongoDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CosmosdbMongoDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
