import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CostManagementExportResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#active CostManagementExportResourceGroup#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#name CostManagementExportResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#recurrence_period_end CostManagementExportResourceGroup#recurrence_period_end}
    */
    readonly recurrencePeriodEnd: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#recurrence_period_start CostManagementExportResourceGroup#recurrence_period_start}
    */
    readonly recurrencePeriodStart: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#recurrence_type CostManagementExportResourceGroup#recurrence_type}
    */
    readonly recurrenceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#resource_group_id CostManagementExportResourceGroup#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * delivery_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#delivery_info CostManagementExportResourceGroup#delivery_info}
    */
    readonly deliveryInfo: CostManagementExportResourceGroupDeliveryInfo;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#query CostManagementExportResourceGroup#query}
    */
    readonly query: CostManagementExportResourceGroupQuery;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#timeouts CostManagementExportResourceGroup#timeouts}
    */
    readonly timeouts?: CostManagementExportResourceGroupTimeouts;
}
export interface CostManagementExportResourceGroupDeliveryInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#container_name CostManagementExportResourceGroup#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#root_folder_path CostManagementExportResourceGroup#root_folder_path}
    */
    readonly rootFolderPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#storage_account_id CostManagementExportResourceGroup#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function costManagementExportResourceGroupDeliveryInfoToTerraform(struct?: CostManagementExportResourceGroupDeliveryInfoOutputReference | CostManagementExportResourceGroupDeliveryInfo): any;
export declare class CostManagementExportResourceGroupDeliveryInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CostManagementExportResourceGroupDeliveryInfo | undefined;
    set internalValue(value: CostManagementExportResourceGroupDeliveryInfo | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _rootFolderPath?;
    get rootFolderPath(): string;
    set rootFolderPath(value: string);
    get rootFolderPathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export interface CostManagementExportResourceGroupQuery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#time_frame CostManagementExportResourceGroup#time_frame}
    */
    readonly timeFrame: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#type CostManagementExportResourceGroup#type}
    */
    readonly type: string;
}
export declare function costManagementExportResourceGroupQueryToTerraform(struct?: CostManagementExportResourceGroupQueryOutputReference | CostManagementExportResourceGroupQuery): any;
export declare class CostManagementExportResourceGroupQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CostManagementExportResourceGroupQuery | undefined;
    set internalValue(value: CostManagementExportResourceGroupQuery | undefined);
    private _timeFrame?;
    get timeFrame(): string;
    set timeFrame(value: string);
    get timeFrameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CostManagementExportResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#create CostManagementExportResourceGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#delete CostManagementExportResourceGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#read CostManagementExportResourceGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group#update CostManagementExportResourceGroup#update}
    */
    readonly update?: string;
}
export declare function costManagementExportResourceGroupTimeoutsToTerraform(struct?: CostManagementExportResourceGroupTimeoutsOutputReference | CostManagementExportResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class CostManagementExportResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CostManagementExportResourceGroupTimeouts | undefined;
    set internalValue(value: CostManagementExportResourceGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group azurerm_cost_management_export_resource_group}
*/
export declare class CostManagementExportResourceGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group azurerm_cost_management_export_resource_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CostManagementExportResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: CostManagementExportResourceGroupConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recurrencePeriodEnd?;
    get recurrencePeriodEnd(): string;
    set recurrencePeriodEnd(value: string);
    get recurrencePeriodEndInput(): string | undefined;
    private _recurrencePeriodStart?;
    get recurrencePeriodStart(): string;
    set recurrencePeriodStart(value: string);
    get recurrencePeriodStartInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    get recurrenceTypeInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _deliveryInfo;
    get deliveryInfo(): CostManagementExportResourceGroupDeliveryInfoOutputReference;
    putDeliveryInfo(value: CostManagementExportResourceGroupDeliveryInfo): void;
    get deliveryInfoInput(): CostManagementExportResourceGroupDeliveryInfo | undefined;
    private _query;
    get query(): CostManagementExportResourceGroupQueryOutputReference;
    putQuery(value: CostManagementExportResourceGroupQuery): void;
    get queryInput(): CostManagementExportResourceGroupQuery | undefined;
    private _timeouts;
    get timeouts(): CostManagementExportResourceGroupTimeoutsOutputReference;
    putTimeouts(value: CostManagementExportResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CostManagementExportResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
