import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#api_management_id DataAzurermApiManagementGateway#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#name DataAzurermApiManagementGateway#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#timeouts DataAzurermApiManagementGateway#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementGatewayTimeouts;
}
export declare class DataAzurermApiManagementGatewayLocationData extends cdktf.ComplexComputedList {
    get city(): string;
    get district(): string;
    get name(): string;
    get region(): string;
}
export interface DataAzurermApiManagementGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway#read DataAzurermApiManagementGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementGatewayTimeoutsToTerraform(struct?: DataAzurermApiManagementGatewayTimeoutsOutputReference | DataAzurermApiManagementGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApiManagementGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermApiManagementGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway azurerm_api_management_gateway}
*/
export declare class DataAzurermApiManagementGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_gateway azurerm_api_management_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementGatewayConfig);
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    get description(): string;
    get id(): string;
    locationData(index: string): DataAzurermApiManagementGatewayLocationData;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApiManagementGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
