import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementProductConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product#api_management_name DataAzurermApiManagementProduct#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product#product_id DataAzurermApiManagementProduct#product_id}
    */
    readonly productId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product#resource_group_name DataAzurermApiManagementProduct#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product#timeouts DataAzurermApiManagementProduct#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementProductTimeouts;
}
export interface DataAzurermApiManagementProductTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product#read DataAzurermApiManagementProduct#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementProductTimeoutsToTerraform(struct?: DataAzurermApiManagementProductTimeoutsOutputReference | DataAzurermApiManagementProductTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementProductTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApiManagementProductTimeouts | undefined;
    set internalValue(value: DataAzurermApiManagementProductTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product azurerm_api_management_product}
*/
export declare class DataAzurermApiManagementProduct extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_product azurerm_api_management_product} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementProductConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementProductConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get approvalRequired(): cdktf.IResolvable;
    get description(): string;
    get displayName(): string;
    get id(): string;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    get productIdInput(): string | undefined;
    get published(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subscriptionRequired(): cdktf.IResolvable;
    get subscriptionsLimit(): number;
    get terms(): string;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementProductTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementProductTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApiManagementProductTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
