import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user#api_management_name DataAzurermApiManagementUser#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user#resource_group_name DataAzurermApiManagementUser#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user#user_id DataAzurermApiManagementUser#user_id}
    */
    readonly userId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user#timeouts DataAzurermApiManagementUser#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementUserTimeouts;
}
export interface DataAzurermApiManagementUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user#read DataAzurermApiManagementUser#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementUserTimeoutsToTerraform(struct?: DataAzurermApiManagementUserTimeoutsOutputReference | DataAzurermApiManagementUserTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApiManagementUserTimeouts | undefined;
    set internalValue(value: DataAzurermApiManagementUserTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user azurerm_api_management_user}
*/
export declare class DataAzurermApiManagementUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_user azurerm_api_management_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementUserConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementUserConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get email(): string;
    get firstName(): string;
    get id(): string;
    get lastName(): string;
    get note(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get state(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementUserTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApiManagementUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
