import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment#name DataAzurermAppServiceEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment#resource_group_name DataAzurermAppServiceEnvironment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment#timeouts DataAzurermAppServiceEnvironment#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceEnvironmentTimeouts;
}
export declare class DataAzurermAppServiceEnvironmentClusterSetting extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export interface DataAzurermAppServiceEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment#read DataAzurermAppServiceEnvironment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceEnvironmentTimeoutsToTerraform(struct?: DataAzurermAppServiceEnvironmentTimeoutsOutputReference | DataAzurermAppServiceEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServiceEnvironmentTimeouts | undefined;
    set internalValue(value: DataAzurermAppServiceEnvironmentTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment azurerm_app_service_environment}
*/
export declare class DataAzurermAppServiceEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment azurerm_app_service_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceEnvironmentConfig);
    clusterSetting(index: string): DataAzurermAppServiceEnvironmentClusterSetting;
    get frontEndScaleFactor(): number;
    get id(): string;
    get internalIpAddress(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    get pricingTier(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceIpAddress(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceEnvironmentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServiceEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
