import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAutomationVariableBoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool#automation_account_name DataAzurermAutomationVariableBool#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool#name DataAzurermAutomationVariableBool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool#resource_group_name DataAzurermAutomationVariableBool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool#timeouts DataAzurermAutomationVariableBool#timeouts}
    */
    readonly timeouts?: DataAzurermAutomationVariableBoolTimeouts;
}
export interface DataAzurermAutomationVariableBoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool#read DataAzurermAutomationVariableBool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAutomationVariableBoolTimeoutsToTerraform(struct?: DataAzurermAutomationVariableBoolTimeoutsOutputReference | DataAzurermAutomationVariableBoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAutomationVariableBoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAutomationVariableBoolTimeouts | undefined;
    set internalValue(value: DataAzurermAutomationVariableBoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool azurerm_automation_variable_bool}
*/
export declare class DataAzurermAutomationVariableBool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_bool azurerm_automation_variable_bool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAutomationVariableBoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationVariableBoolConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get value(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAutomationVariableBoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAutomationVariableBoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAutomationVariableBoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
