import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCdnProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile#name DataAzurermCdnProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile#resource_group_name DataAzurermCdnProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile#timeouts DataAzurermCdnProfile#timeouts}
    */
    readonly timeouts?: DataAzurermCdnProfileTimeouts;
}
export interface DataAzurermCdnProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile#read DataAzurermCdnProfile#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCdnProfileTimeoutsToTerraform(struct?: DataAzurermCdnProfileTimeoutsOutputReference | DataAzurermCdnProfileTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCdnProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermCdnProfileTimeouts | undefined;
    set internalValue(value: DataAzurermCdnProfileTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile azurerm_cdn_profile}
*/
export declare class DataAzurermCdnProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cdn_profile azurerm_cdn_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCdnProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCdnProfileConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermCdnProfileTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCdnProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermCdnProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
