import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermClientConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/client_config#timeouts DataAzurermClientConfig#timeouts}
    */
    readonly timeouts?: DataAzurermClientConfigTimeouts;
}
export interface DataAzurermClientConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/client_config#read DataAzurermClientConfig#read}
    */
    readonly read?: string;
}
export declare function dataAzurermClientConfigTimeoutsToTerraform(struct?: DataAzurermClientConfigTimeoutsOutputReference | DataAzurermClientConfigTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermClientConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermClientConfigTimeouts | undefined;
    set internalValue(value: DataAzurermClientConfigTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/client_config azurerm_client_config}
*/
export declare class DataAzurermClientConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/client_config azurerm_client_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermClientConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermClientConfigConfig);
    get clientId(): string;
    get id(): string;
    get objectId(): string;
    get subscriptionId(): string;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermClientConfigTimeoutsOutputReference;
    putTimeouts(value: DataAzurermClientConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermClientConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
