import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group#name DataAzurermConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group#resource_group_id DataAzurermConsumptionBudgetResourceGroup#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group#timeouts DataAzurermConsumptionBudgetResourceGroup#timeouts}
    */
    readonly timeouts?: DataAzurermConsumptionBudgetResourceGroupTimeouts;
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterDimension extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotDimension extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotTag extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNot extends cdktf.ComplexComputedList {
    get dimension(): cdktf.IResolvable;
    get tag(): cdktf.IResolvable;
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterTag extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilter extends cdktf.ComplexComputedList {
    get dimension(): cdktf.IResolvable;
    get not(): cdktf.IResolvable;
    get tag(): cdktf.IResolvable;
}
export declare class DataAzurermConsumptionBudgetResourceGroupNotification extends cdktf.ComplexComputedList {
    get contactEmails(): string[];
    get contactGroups(): string[];
    get contactRoles(): string[];
    get enabled(): cdktf.IResolvable;
    get operator(): string;
    get threshold(): number;
    get thresholdType(): string;
}
export declare class DataAzurermConsumptionBudgetResourceGroupTimePeriod extends cdktf.ComplexComputedList {
    get endDate(): string;
    get startDate(): string;
}
export interface DataAzurermConsumptionBudgetResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group#read DataAzurermConsumptionBudgetResourceGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetResourceGroupTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference | DataAzurermConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group azurerm_consumption_budget_resource_group}
*/
export declare class DataAzurermConsumptionBudgetResourceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group azurerm_consumption_budget_resource_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermConsumptionBudgetResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetResourceGroupConfig);
    get amount(): number;
    filter(index: string): DataAzurermConsumptionBudgetResourceGroupFilter;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    notification(index: string): DataAzurermConsumptionBudgetResourceGroupNotification;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    get timeGrain(): string;
    timePeriod(index: string): DataAzurermConsumptionBudgetResourceGroupTimePeriod;
    private _timeouts;
    get timeouts(): DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermConsumptionBudgetResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
