import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermConsumptionBudgetSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#name DataAzurermConsumptionBudgetSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#subscription_id DataAzurermConsumptionBudgetSubscription#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#timeouts DataAzurermConsumptionBudgetSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermConsumptionBudgetSubscriptionTimeouts;
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterDimension extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotDimension extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNotTag extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterNot extends cdktf.ComplexComputedList {
    get dimension(): cdktf.IResolvable;
    get tag(): cdktf.IResolvable;
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilterTag extends cdktf.ComplexComputedList {
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetSubscriptionFilter extends cdktf.ComplexComputedList {
    get dimension(): cdktf.IResolvable;
    get not(): cdktf.IResolvable;
    get tag(): cdktf.IResolvable;
}
export declare class DataAzurermConsumptionBudgetSubscriptionNotification extends cdktf.ComplexComputedList {
    get contactEmails(): string[];
    get contactGroups(): string[];
    get contactRoles(): string[];
    get enabled(): cdktf.IResolvable;
    get operator(): string;
    get threshold(): number;
    get thresholdType(): string;
}
export declare class DataAzurermConsumptionBudgetSubscriptionTimePeriod extends cdktf.ComplexComputedList {
    get endDate(): string;
    get startDate(): string;
}
export interface DataAzurermConsumptionBudgetSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription#read DataAzurermConsumptionBudgetSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetSubscriptionTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference | DataAzurermConsumptionBudgetSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription azurerm_consumption_budget_subscription}
*/
export declare class DataAzurermConsumptionBudgetSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_subscription azurerm_consumption_budget_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermConsumptionBudgetSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetSubscriptionConfig);
    get amount(): number;
    filter(index: string): DataAzurermConsumptionBudgetSubscriptionFilter;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    notification(index: string): DataAzurermConsumptionBudgetSubscriptionNotification;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    get timeGrain(): string;
    timePeriod(index: string): DataAzurermConsumptionBudgetSubscriptionTimePeriod;
    private _timeouts;
    get timeouts(): DataAzurermConsumptionBudgetSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermConsumptionBudgetSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermConsumptionBudgetSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
