import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_group#name DataAzurermContainerGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_group#resource_group_name DataAzurermContainerGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_group#timeouts DataAzurermContainerGroup#timeouts}
    */
    readonly timeouts?: DataAzurermContainerGroupTimeouts;
}
export interface DataAzurermContainerGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_group#read DataAzurermContainerGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerGroupTimeoutsToTerraform(struct?: DataAzurermContainerGroupTimeoutsOutputReference | DataAzurermContainerGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermContainerGroupTimeouts | undefined;
    set internalValue(value: DataAzurermContainerGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_group azurerm_container_group}
*/
export declare class DataAzurermContainerGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_group azurerm_container_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerGroupConfig);
    get fqdn(): string;
    get id(): string;
    get ipAddress(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermContainerGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermContainerGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
