import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryScopeMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map#container_registry_name DataAzurermContainerRegistryScopeMap#container_registry_name}
    */
    readonly containerRegistryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map#name DataAzurermContainerRegistryScopeMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map#resource_group_name DataAzurermContainerRegistryScopeMap#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map#timeouts DataAzurermContainerRegistryScopeMap#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryScopeMapTimeouts;
}
export interface DataAzurermContainerRegistryScopeMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map#read DataAzurermContainerRegistryScopeMap#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryScopeMapTimeoutsToTerraform(struct?: DataAzurermContainerRegistryScopeMapTimeoutsOutputReference | DataAzurermContainerRegistryScopeMapTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryScopeMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermContainerRegistryScopeMapTimeouts | undefined;
    set internalValue(value: DataAzurermContainerRegistryScopeMapTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map azurerm_container_registry_scope_map}
*/
export declare class DataAzurermContainerRegistryScopeMap extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_scope_map azurerm_container_registry_scope_map} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryScopeMapConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryScopeMapConfig);
    get actions(): string[];
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    get containerRegistryNameInput(): string | undefined;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryScopeMapTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryScopeMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermContainerRegistryScopeMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
