import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry#name DataAzurermContainerRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry#resource_group_name DataAzurermContainerRegistry#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry#timeouts DataAzurermContainerRegistry#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryTimeouts;
}
export interface DataAzurermContainerRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry#read DataAzurermContainerRegistry#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryTimeoutsToTerraform(struct?: DataAzurermContainerRegistryTimeoutsOutputReference | DataAzurermContainerRegistryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermContainerRegistryTimeouts | undefined;
    set internalValue(value: DataAzurermContainerRegistryTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry azurerm_container_registry}
*/
export declare class DataAzurermContainerRegistry extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry azurerm_container_registry} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryConfig);
    get adminEnabled(): cdktf.IResolvable;
    get adminPassword(): string;
    get adminUsername(): string;
    get id(): string;
    get location(): string;
    get loginServer(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    get storageAccountId(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermContainerRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
