import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#name DataAzurermCosmosdbAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#resource_group_name DataAzurermCosmosdbAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#timeouts DataAzurermCosmosdbAccount#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbAccountTimeouts;
}
export declare class DataAzurermCosmosdbAccountCapabilities extends cdktf.ComplexComputedList {
    get name(): string;
}
export declare class DataAzurermCosmosdbAccountConsistencyPolicy extends cdktf.ComplexComputedList {
    get consistencyLevel(): string;
    get maxIntervalInSeconds(): number;
    get maxStalenessPrefix(): number;
}
export declare class DataAzurermCosmosdbAccountGeoLocation extends cdktf.ComplexComputedList {
    get failoverPriority(): number;
    get id(): string;
    get location(): string;
}
export declare class DataAzurermCosmosdbAccountVirtualNetworkRule extends cdktf.ComplexComputedList {
    get id(): string;
}
export interface DataAzurermCosmosdbAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#read DataAzurermCosmosdbAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbAccountTimeoutsToTerraform(struct?: DataAzurermCosmosdbAccountTimeoutsOutputReference | DataAzurermCosmosdbAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermCosmosdbAccountTimeouts | undefined;
    set internalValue(value: DataAzurermCosmosdbAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account}
*/
export declare class DataAzurermCosmosdbAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbAccountConfig);
    capabilities(index: string): DataAzurermCosmosdbAccountCapabilities;
    consistencyPolicy(index: string): DataAzurermCosmosdbAccountConsistencyPolicy;
    get enableAutomaticFailover(): cdktf.IResolvable;
    get enableFreeTier(): cdktf.IResolvable;
    get enableMultipleWriteLocations(): cdktf.IResolvable;
    get endpoint(): string;
    geoLocation(index: string): DataAzurermCosmosdbAccountGeoLocation;
    get id(): string;
    get ipRangeFilter(): string;
    get isVirtualNetworkFilterEnabled(): cdktf.IResolvable;
    get keyVaultKeyId(): string;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get offerType(): string;
    get primaryKey(): string;
    get primaryMasterKey(): string;
    get primaryReadonlyKey(): string;
    get primaryReadonlyMasterKey(): string;
    get readEndpoints(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    get secondaryMasterKey(): string;
    get secondaryReadonlyKey(): string;
    get secondaryReadonlyMasterKey(): string;
    tags(key: string): string | cdktf.IResolvable;
    virtualNetworkRule(index: string): DataAzurermCosmosdbAccountVirtualNetworkRule;
    get writeEndpoints(): string[];
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermCosmosdbAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
