import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataProtectionBackupVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#name DataAzurermDataProtectionBackupVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#resource_group_name DataAzurermDataProtectionBackupVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#timeouts DataAzurermDataProtectionBackupVault#timeouts}
    */
    readonly timeouts?: DataAzurermDataProtectionBackupVaultTimeouts;
}
export declare class DataAzurermDataProtectionBackupVaultIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermDataProtectionBackupVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault#read DataAzurermDataProtectionBackupVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataProtectionBackupVaultTimeoutsToTerraform(struct?: DataAzurermDataProtectionBackupVaultTimeoutsOutputReference | DataAzurermDataProtectionBackupVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataProtectionBackupVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataProtectionBackupVaultTimeouts | undefined;
    set internalValue(value: DataAzurermDataProtectionBackupVaultTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault azurerm_data_protection_backup_vault}
*/
export declare class DataAzurermDataProtectionBackupVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_protection_backup_vault azurerm_data_protection_backup_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataProtectionBackupVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataProtectionBackupVaultConfig);
    get datastoreType(): string;
    get id(): string;
    identity(index: string): DataAzurermDataProtectionBackupVaultIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get redundancy(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDataProtectionBackupVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataProtectionBackupVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataProtectionBackupVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
