import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDatabricksWorkspacePrivateEndpointConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#private_endpoint_id DataAzurermDatabricksWorkspacePrivateEndpointConnection#private_endpoint_id}
    */
    readonly privateEndpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#workspace_id DataAzurermDatabricksWorkspacePrivateEndpointConnection#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#timeouts DataAzurermDatabricksWorkspacePrivateEndpointConnection#timeouts}
    */
    readonly timeouts?: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts;
}
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnectionConnections extends cdktf.ComplexComputedList {
    get actionRequired(): string;
    get description(): string;
    get name(): string;
    get status(): string;
    get workspacePrivateEndpointId(): string;
}
export interface DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection#read DataAzurermDatabricksWorkspacePrivateEndpointConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsToTerraform(struct?: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference | DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined;
    set internalValue(value: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection azurerm_databricks_workspace_private_endpoint_connection}
*/
export declare class DataAzurermDatabricksWorkspacePrivateEndpointConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace_private_endpoint_connection azurerm_databricks_workspace_private_endpoint_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDatabricksWorkspacePrivateEndpointConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDatabricksWorkspacePrivateEndpointConnectionConfig);
    connections(index: string): DataAzurermDatabricksWorkspacePrivateEndpointConnectionConnections;
    get id(): string;
    private _privateEndpointId?;
    get privateEndpointId(): string;
    set privateEndpointId(value: string);
    get privateEndpointIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDatabricksWorkspacePrivateEndpointConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
