import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#name DataAzurermFirewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#resource_group_name DataAzurermFirewall#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#timeouts DataAzurermFirewall#timeouts}
    */
    readonly timeouts?: DataAzurermFirewallTimeouts;
}
export declare class DataAzurermFirewallIpConfiguration extends cdktf.ComplexComputedList {
    get name(): string;
    get privateIpAddress(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermFirewallManagementIpConfiguration extends cdktf.ComplexComputedList {
    get name(): string;
    get privateIpAddress(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermFirewallVirtualHub extends cdktf.ComplexComputedList {
    get privateIpAddress(): string;
    get publicIpAddresses(): string[];
    get publicIpCount(): number;
    get virtualHubId(): string;
}
export interface DataAzurermFirewallTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#read DataAzurermFirewall#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFirewallTimeoutsToTerraform(struct?: DataAzurermFirewallTimeoutsOutputReference | DataAzurermFirewallTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermFirewallTimeouts | undefined;
    set internalValue(value: DataAzurermFirewallTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/firewall azurerm_firewall}
*/
export declare class DataAzurermFirewall extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/firewall azurerm_firewall} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFirewallConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallConfig);
    get dnsServers(): string[];
    get firewallPolicyId(): string;
    get id(): string;
    ipConfiguration(index: string): DataAzurermFirewallIpConfiguration;
    get location(): string;
    managementIpConfiguration(index: string): DataAzurermFirewallManagementIpConfiguration;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get skuTier(): string;
    tags(key: string): string | cdktf.IResolvable;
    get threatIntelMode(): string;
    virtualHub(index: string): DataAzurermFirewallVirtualHub;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermFirewallTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFirewallTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermFirewallTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
