import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHealthcareServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service#location DataAzurermHealthcareService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service#name DataAzurermHealthcareService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service#resource_group_name DataAzurermHealthcareService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service#timeouts DataAzurermHealthcareService#timeouts}
    */
    readonly timeouts?: DataAzurermHealthcareServiceTimeouts;
}
export declare class DataAzurermHealthcareServiceAuthenticationConfiguration extends cdktf.ComplexComputedList {
    get audience(): string;
    get authority(): string;
    get smartProxyEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermHealthcareServiceCorsConfiguration extends cdktf.ComplexComputedList {
    get allowCredentials(): cdktf.IResolvable;
    get allowedHeaders(): string[];
    get allowedMethods(): string[];
    get allowedOrigins(): string[];
    get maxAgeInSeconds(): number;
}
export interface DataAzurermHealthcareServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service#read DataAzurermHealthcareService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHealthcareServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareServiceTimeoutsOutputReference | DataAzurermHealthcareServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHealthcareServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermHealthcareServiceTimeouts | undefined;
    set internalValue(value: DataAzurermHealthcareServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service azurerm_healthcare_service}
*/
export declare class DataAzurermHealthcareService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/healthcare_service azurerm_healthcare_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHealthcareServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareServiceConfig);
    get accessPolicyObjectIds(): string[];
    authenticationConfiguration(index: string): DataAzurermHealthcareServiceAuthenticationConfiguration;
    corsConfiguration(index: string): DataAzurermHealthcareServiceCorsConfiguration;
    get cosmosdbKeyVaultKeyVersionlessId(): string;
    get cosmosdbThroughput(): number;
    get id(): string;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermHealthcareServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHealthcareServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermHealthcareServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
