import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermImagesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#resource_group_name DataAzurermImages#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#tags_filter DataAzurermImages#tags_filter}
    */
    readonly tagsFilter?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#timeouts DataAzurermImages#timeouts}
    */
    readonly timeouts?: DataAzurermImagesTimeouts;
}
export declare class DataAzurermImagesImagesDataDisk extends cdktf.ComplexComputedList {
    get blobUri(): string;
    get caching(): string;
    get lun(): number;
    get managedDiskId(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImagesImagesOsDisk extends cdktf.ComplexComputedList {
    get blobUri(): string;
    get caching(): string;
    get managedDiskId(): string;
    get osState(): string;
    get osType(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImagesImages extends cdktf.ComplexComputedList {
    get dataDisk(): cdktf.IResolvable;
    get location(): string;
    get name(): string;
    get osDisk(): cdktf.IResolvable;
    get tags(): {
        [key: string]: string;
    };
    get zoneResilient(): cdktf.IResolvable;
}
export interface DataAzurermImagesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/images#read DataAzurermImages#read}
    */
    readonly read?: string;
}
export declare function dataAzurermImagesTimeoutsToTerraform(struct?: DataAzurermImagesTimeoutsOutputReference | DataAzurermImagesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermImagesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermImagesTimeouts | undefined;
    set internalValue(value: DataAzurermImagesTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/images azurerm_images}
*/
export declare class DataAzurermImages extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/images azurerm_images} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermImagesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermImagesConfig);
    get id(): string;
    images(index: string): DataAzurermImagesImages;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    get tagsFilter(): {
        [key: string]: string;
    };
    set tagsFilter(value: {
        [key: string]: string;
    });
    resetTagsFilter(): void;
    get tagsFilterInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermImagesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermImagesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermImagesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
