import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificateIssuerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer#key_vault_id DataAzurermKeyVaultCertificateIssuer#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer#name DataAzurermKeyVaultCertificateIssuer#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer#timeouts DataAzurermKeyVaultCertificateIssuer#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificateIssuerTimeouts;
}
export declare class DataAzurermKeyVaultCertificateIssuerAdmin extends cdktf.ComplexComputedList {
    get emailAddress(): string;
    get firstName(): string;
    get lastName(): string;
    get phone(): string;
}
export interface DataAzurermKeyVaultCertificateIssuerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer#read DataAzurermKeyVaultCertificateIssuer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateIssuerTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateIssuerTimeoutsOutputReference | DataAzurermKeyVaultCertificateIssuerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificateIssuerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateIssuerTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateIssuerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer azurerm_key_vault_certificate_issuer}
*/
export declare class DataAzurermKeyVaultCertificateIssuer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_certificate_issuer azurerm_key_vault_certificate_issuer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificateIssuerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateIssuerConfig);
    get accountId(): string;
    admin(index: string): DataAzurermKeyVaultCertificateIssuerAdmin;
    get id(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get orgId(): string;
    get providerName(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificateIssuerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificateIssuerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultCertificateIssuerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
