import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#key_vault_id DataAzurermKeyVaultKey#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#name DataAzurermKeyVaultKey#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#timeouts DataAzurermKeyVaultKey#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultKeyTimeouts;
}
export interface DataAzurermKeyVaultKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key#read DataAzurermKeyVaultKey#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultKeyTimeoutsToTerraform(struct?: DataAzurermKeyVaultKeyTimeoutsOutputReference | DataAzurermKeyVaultKeyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKeyVaultKeyTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultKeyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key azurerm_key_vault_key}
*/
export declare class DataAzurermKeyVaultKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_key azurerm_key_vault_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultKeyConfig);
    get curve(): string;
    get e(): string;
    get id(): string;
    get keyOpts(): string[];
    get keySize(): number;
    get keyType(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    get n(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicKeyOpenssh(): string;
    get publicKeyPem(): string;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    get versionlessId(): string;
    get x(): string;
    get y(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultKeyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
