import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault#name DataAzurermKeyVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault#resource_group_name DataAzurermKeyVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault#timeouts DataAzurermKeyVault#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultTimeouts;
}
export declare class DataAzurermKeyVaultAccessPolicy extends cdktf.ComplexComputedList {
    get applicationId(): string;
    get certificatePermissions(): string[];
    get keyPermissions(): string[];
    get objectId(): string;
    get secretPermissions(): string[];
    get storagePermissions(): string[];
    get tenantId(): string;
}
export declare class DataAzurermKeyVaultNetworkAcls extends cdktf.ComplexComputedList {
    get bypass(): string;
    get defaultAction(): string;
    get ipRules(): string[];
    get virtualNetworkSubnetIds(): string[];
}
export interface DataAzurermKeyVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault#read DataAzurermKeyVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultTimeoutsToTerraform(struct?: DataAzurermKeyVaultTimeoutsOutputReference | DataAzurermKeyVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKeyVaultTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault azurerm_key_vault}
*/
export declare class DataAzurermKeyVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault azurerm_key_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultConfig);
    accessPolicy(index: string): DataAzurermKeyVaultAccessPolicy;
    get enableRbacAuthorization(): cdktf.IResolvable;
    get enabledForDeployment(): cdktf.IResolvable;
    get enabledForDiskEncryption(): cdktf.IResolvable;
    get enabledForTemplateDeployment(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    networkAcls(index: string): DataAzurermKeyVaultNetworkAcls;
    get purgeProtectionEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get softDeleteEnabled(): cdktf.IResolvable;
    tags(key: string): string | cdktf.IResolvable;
    get tenantId(): string;
    get vaultUri(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
