import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogicAppIntegrationAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account#name DataAzurermLogicAppIntegrationAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account#resource_group_name DataAzurermLogicAppIntegrationAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account#timeouts DataAzurermLogicAppIntegrationAccount#timeouts}
    */
    readonly timeouts?: DataAzurermLogicAppIntegrationAccountTimeouts;
}
export interface DataAzurermLogicAppIntegrationAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account#read DataAzurermLogicAppIntegrationAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogicAppIntegrationAccountTimeoutsToTerraform(struct?: DataAzurermLogicAppIntegrationAccountTimeoutsOutputReference | DataAzurermLogicAppIntegrationAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogicAppIntegrationAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogicAppIntegrationAccountTimeouts | undefined;
    set internalValue(value: DataAzurermLogicAppIntegrationAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account azurerm_logic_app_integration_account}
*/
export declare class DataAzurermLogicAppIntegrationAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_integration_account azurerm_logic_app_integration_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogicAppIntegrationAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogicAppIntegrationAccountConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLogicAppIntegrationAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogicAppIntegrationAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLogicAppIntegrationAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
