import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlManagedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance#name DataAzurermMssqlManagedInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance#resource_group_name DataAzurermMssqlManagedInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance#timeouts DataAzurermMssqlManagedInstance#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlManagedInstanceTimeouts;
}
export declare class DataAzurermMssqlManagedInstanceIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermMssqlManagedInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance#read DataAzurermMssqlManagedInstance#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlManagedInstanceTimeoutsToTerraform(struct?: DataAzurermMssqlManagedInstanceTimeoutsOutputReference | DataAzurermMssqlManagedInstanceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlManagedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMssqlManagedInstanceTimeouts | undefined;
    set internalValue(value: DataAzurermMssqlManagedInstanceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance azurerm_mssql_managed_instance}
*/
export declare class DataAzurermMssqlManagedInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_managed_instance azurerm_mssql_managed_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlManagedInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlManagedInstanceConfig);
    get administratorLogin(): string;
    get collation(): string;
    get dnsZonePartnerId(): string;
    get fqdn(): string;
    get id(): string;
    identity(index: string): DataAzurermMssqlManagedInstanceIdentity;
    get licenseType(): string;
    get location(): string;
    get minimumTlsVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get proxyOverride(): string;
    get publicDataEndpointEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get storageAccountType(): string;
    get storageSizeInGb(): number;
    get subnetId(): string;
    tags(key: string): string | cdktf.IResolvable;
    get timezoneId(): string;
    get vcores(): number;
    private _timeouts;
    get timeouts(): DataAzurermMssqlManagedInstanceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlManagedInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMssqlManagedInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
