import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappSnapshotPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy#account_name DataAzurermNetappSnapshotPolicy#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy#name DataAzurermNetappSnapshotPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy#resource_group_name DataAzurermNetappSnapshotPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy#timeouts DataAzurermNetappSnapshotPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermNetappSnapshotPolicyTimeouts;
}
export declare class DataAzurermNetappSnapshotPolicyDailySchedule extends cdktf.ComplexComputedList {
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyHourlySchedule extends cdktf.ComplexComputedList {
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyMonthlySchedule extends cdktf.ComplexComputedList {
    get daysOfMonth(): number[];
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export declare class DataAzurermNetappSnapshotPolicyWeeklySchedule extends cdktf.ComplexComputedList {
    get daysOfWeek(): string[];
    get hour(): number;
    get minute(): number;
    get snapshotsToKeep(): number;
}
export interface DataAzurermNetappSnapshotPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy#read DataAzurermNetappSnapshotPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappSnapshotPolicyTimeoutsToTerraform(struct?: DataAzurermNetappSnapshotPolicyTimeoutsOutputReference | DataAzurermNetappSnapshotPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappSnapshotPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetappSnapshotPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermNetappSnapshotPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy azurerm_netapp_snapshot_policy}
*/
export declare class DataAzurermNetappSnapshotPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy azurerm_netapp_snapshot_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappSnapshotPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappSnapshotPolicyConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    dailySchedule(index: string): DataAzurermNetappSnapshotPolicyDailySchedule;
    get enabled(): cdktf.IResolvable;
    hourlySchedule(index: string): DataAzurermNetappSnapshotPolicyHourlySchedule;
    get id(): string;
    get location(): string;
    monthlySchedule(index: string): DataAzurermNetappSnapshotPolicyMonthlySchedule;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    weeklySchedule(index: string): DataAzurermNetappSnapshotPolicyWeeklySchedule;
    private _timeouts;
    get timeouts(): DataAzurermNetappSnapshotPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappSnapshotPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetappSnapshotPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
