import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#name DataAzurermNetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#resource_group_name DataAzurermNetworkInterface#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#timeouts DataAzurermNetworkInterface#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkInterfaceTimeouts;
}
export declare class DataAzurermNetworkInterfaceIpConfiguration extends cdktf.ComplexComputedList {
    get applicationGatewayBackendAddressPoolsIds(): string[];
    get applicationSecurityGroupIds(): string[];
    get gatewayLoadBalancerFrontendIpConfigurationId(): string;
    get loadBalancerBackendAddressPoolsIds(): string[];
    get loadBalancerInboundNatRulesIds(): string[];
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateIpAddressVersion(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export interface DataAzurermNetworkInterfaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#read DataAzurermNetworkInterface#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkInterfaceTimeoutsToTerraform(struct?: DataAzurermNetworkInterfaceTimeoutsOutputReference | DataAzurermNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetworkInterfaceTimeouts | undefined;
    set internalValue(value: DataAzurermNetworkInterfaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface azurerm_network_interface}
*/
export declare class DataAzurermNetworkInterface extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface azurerm_network_interface} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkInterfaceConfig);
    get appliedDnsServers(): string[];
    get dnsServers(): string[];
    get enableAcceleratedNetworking(): cdktf.IResolvable;
    get enableIpForwarding(): cdktf.IResolvable;
    get id(): string;
    get internalDnsNameLabel(): string;
    ipConfiguration(index: string): DataAzurermNetworkInterfaceIpConfiguration;
    get location(): string;
    get macAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSecurityGroupId(): string;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get virtualMachineId(): string;
    private _timeouts;
    get timeouts(): DataAzurermNetworkInterfaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkInterfaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetworkInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
