import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNotificationHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#name DataAzurermNotificationHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#namespace_name DataAzurermNotificationHub#namespace_name}
    */
    readonly namespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#resource_group_name DataAzurermNotificationHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#timeouts DataAzurermNotificationHub#timeouts}
    */
    readonly timeouts?: DataAzurermNotificationHubTimeouts;
}
export declare class DataAzurermNotificationHubApnsCredential extends cdktf.ComplexComputedList {
    get applicationMode(): string;
    get bundleId(): string;
    get keyId(): string;
    get teamId(): string;
    get token(): string;
}
export declare class DataAzurermNotificationHubGcmCredential extends cdktf.ComplexComputedList {
    get apiKey(): string;
}
export interface DataAzurermNotificationHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#read DataAzurermNotificationHub#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNotificationHubTimeoutsToTerraform(struct?: DataAzurermNotificationHubTimeoutsOutputReference | DataAzurermNotificationHubTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNotificationHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNotificationHubTimeouts | undefined;
    set internalValue(value: DataAzurermNotificationHubTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub azurerm_notification_hub}
*/
export declare class DataAzurermNotificationHub extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub azurerm_notification_hub} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNotificationHubConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNotificationHubConfig);
    apnsCredential(index: string): DataAzurermNotificationHubApnsCredential;
    gcmCredential(index: string): DataAzurermNotificationHubGcmCredential;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermNotificationHubTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNotificationHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNotificationHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
