import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPortalDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard#dashboard_properties DataAzurermPortalDashboard#dashboard_properties}
    */
    readonly dashboardProperties?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard#name DataAzurermPortalDashboard#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard#resource_group_name DataAzurermPortalDashboard#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard#timeouts DataAzurermPortalDashboard#timeouts}
    */
    readonly timeouts?: DataAzurermPortalDashboardTimeouts;
}
export interface DataAzurermPortalDashboardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard#read DataAzurermPortalDashboard#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPortalDashboardTimeoutsToTerraform(struct?: DataAzurermPortalDashboardTimeoutsOutputReference | DataAzurermPortalDashboardTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPortalDashboardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPortalDashboardTimeouts | undefined;
    set internalValue(value: DataAzurermPortalDashboardTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard azurerm_portal_dashboard}
*/
export declare class DataAzurermPortalDashboard extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/portal_dashboard azurerm_portal_dashboard} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPortalDashboardConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPortalDashboardConfig);
    private _dashboardProperties?;
    get dashboardProperties(): string;
    set dashboardProperties(value: string);
    resetDashboardProperties(): void;
    get dashboardPropertiesInput(): string | undefined;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermPortalDashboardTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPortalDashboardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPortalDashboardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
