import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPostgresqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#name DataAzurermPostgresqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#resource_group_name DataAzurermPostgresqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#timeouts DataAzurermPostgresqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataAzurermPostgresqlFlexibleServerTimeouts;
}
export interface DataAzurermPostgresqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server#read DataAzurermPostgresqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPostgresqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference | DataAzurermPostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPostgresqlFlexibleServerTimeouts | undefined;
    set internalValue(value: DataAzurermPostgresqlFlexibleServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server azurerm_postgresql_flexible_server}
*/
export declare class DataAzurermPostgresqlFlexibleServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_flexible_server azurerm_postgresql_flexible_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPostgresqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPostgresqlFlexibleServerConfig);
    get administratorLogin(): string;
    get backupRetentionDays(): number;
    get cmkEnabled(): string;
    get delegatedSubnetId(): string;
    get fqdn(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get storageMb(): number;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermPostgresqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPostgresqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPostgresqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
