import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPostgresqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#name DataAzurermPostgresqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#resource_group_name DataAzurermPostgresqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#timeouts DataAzurermPostgresqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermPostgresqlServerTimeouts;
}
export declare class DataAzurermPostgresqlServerIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermPostgresqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#read DataAzurermPostgresqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPostgresqlServerTimeoutsToTerraform(struct?: DataAzurermPostgresqlServerTimeoutsOutputReference | DataAzurermPostgresqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPostgresqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPostgresqlServerTimeouts | undefined;
    set internalValue(value: DataAzurermPostgresqlServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server azurerm_postgresql_server}
*/
export declare class DataAzurermPostgresqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server azurerm_postgresql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPostgresqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPostgresqlServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    get id(): string;
    identity(index: string): DataAzurermPostgresqlServerIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermPostgresqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPostgresqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPostgresqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
