import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateLinkServiceEndpointConnectionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#resource_group_name DataAzurermPrivateLinkServiceEndpointConnections#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#service_id DataAzurermPrivateLinkServiceEndpointConnections#service_id}
    */
    readonly serviceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#timeouts DataAzurermPrivateLinkServiceEndpointConnections#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts;
}
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections extends cdktf.ComplexComputedList {
    get actionRequired(): string;
    get connectionId(): string;
    get connectionName(): string;
    get description(): string;
    get privateEndpointId(): string;
    get privateEndpointName(): string;
    get status(): string;
}
export interface DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#read DataAzurermPrivateLinkServiceEndpointConnections#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsToTerraform(struct?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference | DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections}
*/
export declare class DataAzurermPrivateLinkServiceEndpointConnections extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateLinkServiceEndpointConnectionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateLinkServiceEndpointConnectionsConfig);
    get id(): string;
    get location(): string;
    privateEndpointConnections(index: string): DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get serviceName(): string;
    private _timeouts;
    get timeouts(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
